<?php

namespace App\Livewire\Admin\Articles;

use App\Models\Article;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Layout;
use Illuminate\Support\Str;

#[Layout('layouts.admin')]
class Create extends Component
{
    use WithFileUploads;

    public $title;
    public $content;
    public $image;
    public $status = 'published';

    public function save()
    {
        $this->validate([
            'title' => 'required|min:3',
            'content' => 'required|min:10',
            'image' => 'nullable|image|max:2048',
            'status' => 'required|in:draft,published',
        ]);

        $imagePath = null;
        if ($this->image) {
            $imagePath = $this->image->store('articles', 'public');
        }

        Article::create([
            'title' => $this->title,
            'slug' => Str::slug($this->title) . '-' . uniqid(),
            'content' => $this->content,
            'image' => $imagePath,
            'status' => $this->status,
            'author_id' => auth()->id(),
            'published_at' => $this->status === 'published' ? now() : null,
        ]);

        return redirect()->route('admin.articles.index')->with('success', 'Article created successfully.');
    }

    public function render()
    {
        return view('livewire.admin.articles.create');
    }
}
