<?php

namespace App\Livewire\Admin\Cars;

use App\Models\Car;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public $search = '';
    public $sortField = 'created_at';
    public $sortDirection = 'desc';

    protected $queryString = ['search', 'sortField', 'sortDirection'];

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function delete($id)
    {
        $car = Car::find($id);
        if ($car) {
            $car->delete();
            session()->flash('success', 'Car deleted successfully.');
        }
    }

    public function updateStatus($id, $status)
    {
        $validStatuses = ['available', 'booked', 'maintenance'];
        if (!in_array($status, $validStatuses)) {
            return;
        }
        
        $car = Car::find($id);
        if ($car) {
            $car->status = $status;
            $car->save();
            session()->flash('success', 'Status updated successfully.');
        }
    }

    public function render()
    {
        $cars = Car::query()
            ->with('brand')
            ->where('name', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(10);

        return view('livewire.admin.cars.index', [
            'cars' => $cars
        ])->layout('layouts.admin');
    }
}
