<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Car;
use App\Models\Motor;
use App\Models\CarBooking; // Assuming you have this or will have it
use App\Models\MotorBooking; // Assuming you have this or will have it

class Dashboard extends Component
{
    public function render()
    {
        $stats = [
            'leads_today' => \App\Models\ActivityLog::where('action', 'booking_submission')->whereDate('created_at', today())->count(),
            'clicks_today' => \App\Models\ActivityLog::where('action', 'whatsapp_floating')->whereDate('created_at', today())->count(),
            'total_leads' => \App\Models\ActivityLog::where('action', 'booking_submission')->count(),
        ];

        $recentActivity = \App\Models\ActivityLog::latest()->take(5)->get();

        $popularItems = \App\Models\ActivityLog::where('action', 'booking_submission')
            ->select('description', \Illuminate\Support\Facades\DB::raw('count(*) as total'))
            ->groupBy('description')
            ->orderByDesc('total')
            ->take(5)
            ->get();

        $carStats = [
            'total' => Car::count(),
            'available' => Car::where('status', 'available')->count(),
            'booked' => Car::where('status', 'booked')->count(),
            'maintenance' => Car::where('status', 'maintenance')->count(),
        ];

        $motorStats = [
            'total' => Motor::count(),
            'available' => Motor::where('status', 'available')->count(),
            'booked' => Motor::where('status', 'booked')->count(),
            'maintenance' => Motor::where('status', 'maintenance')->count(),
        ];

        return view('livewire.admin.dashboard', [
            'carStats' => $carStats,
            'motorStats' => $motorStats,
            'stats' => $stats,
            'recentActivity' => $recentActivity,
            'popularItems' => $popularItems,
        ])->layout('layouts.admin');
    }
}
