<?php

namespace App\Livewire\Admin\Motors;

use App\Models\Motor;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public $search = '';
    public $sortField = 'created_at';
    public $sortDirection = 'desc';

    protected $queryString = ['search', 'sortField', 'sortDirection'];

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function delete($id)
    {
        $motor = Motor::find($id);
        if ($motor) {
            $motor->delete();
            session()->flash('success', 'Motorbike deleted successfully.');
        }
    }

    public function updateStatus($id, $status)
    {
        $validStatuses = ['available', 'booked', 'maintenance'];
        if (!in_array($status, $validStatuses)) {
            return;
        }
        
        $motor = Motor::find($id);
        if ($motor) {
            $motor->status = $status;
            $motor->save();
            session()->flash('success', 'Status updated successfully.');
        }
    }

    public function render()
    {
        $motors = Motor::query()
            ->with('brand')
            ->where('name', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(10);

        return view('livewire.admin.motors.index', [
            'motors' => $motors
        ])->layout('layouts.admin');
    }
}
