<?php

namespace App\Livewire\Admin\Tours;

use App\Models\Tour;
use Livewire\Component;
use Livewire\WithFileUploads;

class Create extends Component
{
    use WithFileUploads;

    public $name;
    public $description;
    public $duration;
    public $price;
    public $price_motor;
    public $main_image;
    public $images = []; // Multi-image gallery
    public $category = 'Nature';
    public $difficulty = 'Easy';
    public $max_people = 10;
    public $status = 'active';

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'duration' => 'required|string', // e.g. "3 Days 2 Nights"
            'price' => 'required|numeric|min:0',
            'price_motor' => 'nullable|numeric|min:0',
            'main_image' => 'required|image|max:10240', // 10MB Max
            'images.*' => 'image|max:10240', // Gallery validation
            'category' => 'required|string',
            'difficulty' => 'required|in:Easy,Medium,Hard',
            'max_people' => 'required|integer|min:1',
            'status' => 'required|in:active,inactive',
        ];
    }

    public function save()
    {
        $validatedData = $this->validate();

        if ($this->main_image) {
            $validatedData['main_image'] = $this->main_image->store('tours', 'public');
        }

        // Handle Gallery
        if ($this->images) {
            $galleryPaths = [];
            foreach ($this->images as $image) {
                $galleryPaths[] = $image->store('tours/gallery', 'public');
            }
            $validatedData['images'] = $galleryPaths;
        }

        Tour::create($validatedData);

        session()->flash('success', 'Tour package created successfully.');

        return redirect()->route('admin.tours.index');
    }

    public function render()
    {
        return view('livewire.admin.tours.create')->layout('layouts.admin');
    }
}
