<?php

namespace App\Livewire\Admin\Tours;

use App\Models\Tour;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public $search = '';
    public $sortField = 'created_at';
    public $sortDirection = 'desc';

    protected $queryString = ['search', 'sortField', 'sortDirection'];

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function delete($id)
    {
        $tour = Tour::find($id);
        if ($tour) {
            $tour->delete();
            session()->flash('success', 'Tour package deleted successfully.');
        }
    }

    public function render()
    {
        $tours = Tour::query()
            ->where('name', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(10);

        return view('livewire.admin.tours.index', [
            'tours' => $tours
        ])->layout('layouts.admin');
    }
}
