<?php

namespace App\Livewire\Articles;

use App\Models\Article;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.app')]
class Show extends Component
{
    public Article $article;

    public function mount(Article $article)
    {
        if ($article->status !== 'published') {
            abort(404);
        }
        $this->article = $article;
    }

    public function render()
    {
        return view('livewire.articles.show', [
            'latestArticles' => Article::published()
                ->where('id', '!=', $this->article->id)
                ->latest()
                ->take(3)
                ->get()
        ]);
    }
}
