<?php

namespace App\Livewire\Cars;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Car;
use App\Models\CarBrand;

#[Layout('layouts.app')]
class Index extends Component
{
    public $brandFilter = '';
    public $transmissionFilter = '';
    public $brands = [];

    protected $queryString = [
        'brandFilter' => ['as' => 'brand'],
        'transmissionFilter' => ['as' => 'transmission'],
    ];


    public function mount()
    {
        $this->brands = CarBrand::orderBy('name')->pluck('name', 'id');
    }

    public function render()
    {
        $cars = Car::where('status', 'available')
            ->when($this->brandFilter, function ($query) {
                $query->where('brand_id', $this->brandFilter);
            })
            ->when($this->transmissionFilter, function ($query) {
                $query->where('transmission', $this->transmissionFilter);
            })
            ->with('brand')
            ->latest()
            ->get();

        return view('livewire.cars.index', [
            'cars' => $cars,
        ]);
    }

    public function clearFilters()
    {
        $this->brandFilter = '';
        $this->transmissionFilter = '';
    }
}
