<?php

namespace App\Livewire\Cars;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Car;
use App\Models\Setting;

#[Layout('layouts.app')]
class Show extends Component
{
    public Car $car;
    public $whatsappNumber;
    public $bookingMessage;

    public $bookingName = '';
    public $bookingDate = '';
    public $bookingDuration = 1;

    public function mount(Car $car)
    {
        $this->car = $car;
        $this->whatsappNumber = Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
    }

    public function submitBooking()
    {
        $this->validate([
            'bookingName' => 'required|string|max:255',
            'bookingDate' => 'required|date',
            'bookingDuration' => 'required|numeric|min:1',
        ]);

        // Log the activity
        \App\Models\ActivityLog::create([
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
            'user_id' => auth()->id(),
            'action' => 'booking_submission',
            'description' => "Booking Request for Car: {$this->car->name}",
            'details' => [
                'item_type' => 'car',
                'item_id' => $this->car->id,
                'item_name' => $this->car->name,
                'customer_name' => $this->bookingName,
                'booking_date' => $this->bookingDate,
                'duration' => $this->bookingDuration,
            ],
            'url' => request()->fullUrl(),
        ]);

        // Construct WhatsApp Message
        $text = "Hello! I would like to book *{$this->car->name}*.\n\n" .
                "Name: {$this->bookingName}\n" .
                "Date: {$this->bookingDate}\n" .
                "Duration: {$this->bookingDuration} Days";
        
        $url = "https://wa.me/{$this->whatsappNumber}?text=" . urlencode($text);

        $this->dispatch('open-whatsapp', url: $url);
    }

    public function render()
    {
        return view('livewire.cars.show');
    }
}
