<?php

namespace App\Livewire\Components;

use Livewire\Component;
use App\Models\Car;
use App\Models\Setting;

class CarCard extends Component
{
    public Car $car;
    public $whatsappNumber;

    public function mount(Car $car)
    {
        $this->car = $car;
        $this->whatsappNumber = Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
    }

    public function render()
    {
        return view('livewire.components.car-card');
    }
}
