<?php

namespace App\Livewire\Components;

use Livewire\Component;
use App\Models\Motor;
use App\Models\Setting;

class MotorCard extends Component
{
    public Motor $motor;
    public $whatsappNumber;

    public function mount(Motor $motor)
    {
        $this->motor = $motor;
        $this->whatsappNumber = Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
    }

    public function render()
    {
        return view('livewire.components.motor-card');
    }
}
