<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Car;
use App\Models\Motor;
use App\Models\Tour;

#[Layout("layouts.app")]
class Home extends Component
{
    public function render()
    {
        return view("livewire.home", [
            "featuredCars" => Car::where("status", "available")
                ->with("brand")
                ->take(4)
                ->get(),
            "featuredMotors" => Motor::where("status", "available")
                ->with("brand")
                ->take(4)
                ->get(),
            "featuredTours" => Tour::where("status", "active")->take(3)->get(),
            "latestArticles" => \App\Models\Article::published()->latest()->take(3)->get(),
        ]);
    }
}
