<?php

namespace App\Livewire\Motors;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Motor;
use App\Models\MotorBrand;

#[Layout('layouts.app')]
class Index extends Component
{
    public $brandFilter = '';
    public $transmissionFilter = '';
    public $brands = [];

    protected $queryString = [
        'brandFilter' => ['as' => 'brand'],
        'transmissionFilter' => ['as' => 'transmission'],
    ];


    public function mount()
    {
        $this->brands = MotorBrand::orderBy('name')->pluck('name', 'id');
    }

    public function render()
    {
        $motors = Motor::where('status', 'available')
            ->when($this->brandFilter, function ($query) {
                $query->where('brand_id', $this->brandFilter);
            })
            ->when($this->transmissionFilter, function ($query) {
                $query->where('transmission', $this->transmissionFilter);
            })
            ->with('brand')
            ->latest()
            ->get();

        return view('livewire.motors.index', [
            'motors' => $motors,
        ]);
    }

    public function clearFilters()
    {
        $this->brandFilter = '';
        $this->transmissionFilter = '';
    }
}
