<?php

namespace App\Livewire\Motors;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Motor;
use App\Models\Setting;

#[Layout('layouts.app')]
class Show extends Component
{
    public Motor $motor;
    public $whatsappNumber;
    public $bookingMessage;

    public $bookingName = '';
    public $bookingDate = '';
    public $bookingDuration = 1;

    public function mount(Motor $motor)
    {
        $this->motor = $motor;
        $this->whatsappNumber = Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
    }

    public function submitBooking()
    {
        $this->validate([
            'bookingName' => 'required|string|max:255',
            'bookingDate' => 'required|date',
            'bookingDuration' => 'required|numeric|min:1',
        ]);

        // Log the activity
        \App\Models\ActivityLog::create([
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
            'user_id' => auth()->id(),
            'action' => 'booking_submission',
            'description' => "Booking Request for Motor: {$this->motor->name}",
            'details' => [
                'item_type' => 'motor',
                'item_id' => $this->motor->id,
                'item_name' => $this->motor->name,
                'customer_name' => $this->bookingName,
                'booking_date' => $this->bookingDate,
                'duration' => $this->bookingDuration,
            ],
            'url' => request()->fullUrl(),
        ]);

        // Construct WhatsApp Message
        $text = "Hello! I would like to book *{$this->motor->name}*.\n\n" .
                "Name: {$this->bookingName}\n" .
                "Date: {$this->bookingDate}\n" .
                "Duration: {$this->bookingDuration} Days";
        
        $url = "https://wa.me/{$this->whatsappNumber}?text=" . urlencode($text);

        $this->dispatch('open-whatsapp', url: $url);
    }

    public function render()
    {
        return view('livewire.motors.show');
    }
}
