<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'images' => 'array',
        'features' => 'array',
        'price_daily' => 'decimal:2',
        'price_weekly' => 'decimal:2',
        'price_monthly' => 'decimal:2',
    ];

    public function brand()
    {
        return $this->belongsTo(CarBrand::class);
    }

    public function bookings()
    {
        return $this->hasMany(CarBooking::class);
    }
}
