<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MotorBooking extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'rental_date' => 'datetime',
        'total_price' => 'decimal:2',
    ];

    public function motor()
    {
        return $this->belongsTo(Motor::class);
    }
}
