<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('motors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->foreignId('brand_id')->constrained('motor_brands')->onDelete('cascade');
            $table->integer('cc');
            $table->string('transmission');
            $table->string('fuel_type');
            $table->decimal('price_daily', 12, 2);
            $table->decimal('price_weekly', 12, 2)->nullable();
            $table->decimal('price_monthly', 12, 2)->nullable();
            $table->string('main_image');
            $table->json('images')->nullable();
            $table->string('status')->default('available');
            $table->json('features')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('motors');
    }
};
