<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('motor_bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('motor_id')->constrained('motors')->onDelete('cascade');
            $table->string('motor_name'); // Snapshot
            $table->string('customer_name');
            $table->string('customer_phone');
            $table->dateTime('rental_date');
            $table->integer('duration');
            $table->string('duration_unit')->default('days');
            $table->string('delivery_location');
            $table->text('notes')->nullable();
            $table->decimal('total_price', 12, 2)->nullable();
            $table->string('status')->default('pending');
            $table->text('whatsapp_message');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('motor_bookings');
    }
};
