<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tour_bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tour_id')->constrained('tours')->onDelete('cascade');
            $table->string('tour_name'); // Snapshot
            $table->string('customer_name');
            $table->string('customer_phone');
            $table->dateTime('tour_date');
            $table->integer('number_of_people');
            $table->boolean('with_motor')->default(false);
            $table->text('notes')->nullable();
            $table->decimal('total_price', 12, 2)->nullable();
            $table->string('status')->default('pending');
            $table->text('whatsapp_message');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tour_bookings');
    }
};
