<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Tour;

class TourSeeder extends Seeder
{
    public function run(): void
    {
        $tours = [
            [
                'name' => 'Nusa Penida Island Tour',
                'description' => 'Explore the stunning cliffs, beaches, and crystal-clear waters of Nusa Penida Island. Visit iconic spots like Kelingking Beach, Angel\'s Billabong, and Broken Beach.',
                'duration' => '12 Hours',
                'price' => 850000,
                'price_motor' => 650000,
                'main_image' => 'https://images.unsplash.com/photo-1596408501646-68b6d856d108?w=800',
                'images' => [
                    'https://images.unsplash.com/photo-1596408501646-68b6d856d108?w=800',
                    'https://images.unsplash.com/photo-1539367628448-4bc5c9d171c8?w=800',
                ],
                'category' => 'Island',
                'difficulty' => 'Medium',
                'max_people' => 8,
                'highlights' => ['Kelingking Beach', 'Angel\'s Billabong', 'Broken Beach', 'Crystal Bay'],
                'includes' => ['Fast boat tickets', 'Land transport', 'Entrance fees', 'Lunch', 'Mineral water'],
                'excludes' => ['Personal expenses', 'Tips', 'Travel insurance'],
                'itinerary' => [
                    ['time' => '06:00', 'activity' => 'Hotel pickup'],
                    ['time' => '07:30', 'activity' => 'Fast boat departure from Sanur'],
                    ['time' => '08:30', 'activity' => 'Arrive at Nusa Penida'],
                    ['time' => '09:00', 'activity' => 'Visit Kelingking Beach'],
                    ['time' => '11:00', 'activity' => 'Angel\'s Billabong & Broken Beach'],
                    ['time' => '13:00', 'activity' => 'Lunch at local restaurant'],
                    ['time' => '14:30', 'activity' => 'Crystal Bay for snorkeling'],
                    ['time' => '17:00', 'activity' => 'Return to Bali'],
                ],
                'status' => 'active',
            ],
            [
                'name' => 'Mount Batur Sunrise Trek',
                'description' => 'Witness a breathtaking sunrise from the summit of Mount Batur, an active volcano. Enjoy panoramic views of Lake Batur and the surrounding mountains.',
                'duration' => '8 Hours',
                'price' => 550000,
                'price_motor' => 450000,
                'main_image' => 'https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=800',
                'images' => [
                    'https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=800',
                    'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800',
                ],
                'category' => 'Adventure',
                'difficulty' => 'Hard',
                'max_people' => 10,
                'highlights' => ['Sunrise view', 'Active volcano', 'Lake Batur view', 'Breakfast on summit'],
                'includes' => ['Transport', 'Trekking guide', 'Breakfast', 'Flashlight', 'Mineral water'],
                'excludes' => ['Personal expenses', 'Trekking shoes rental', 'Tips'],
                'itinerary' => [
                    ['time' => '02:00', 'activity' => 'Hotel pickup'],
                    ['time' => '04:00', 'activity' => 'Start trekking'],
                    ['time' => '06:00', 'activity' => 'Reach summit for sunrise'],
                    ['time' => '07:00', 'activity' => 'Breakfast with volcano view'],
                    ['time' => '08:00', 'activity' => 'Descend the mountain'],
                    ['time' => '10:00', 'activity' => 'Return to hotel'],
                ],
                'status' => 'active',
            ],
            [
                'name' => 'Ubud Cultural Day Trip',
                'description' => 'Immerse yourself in Balinese culture with visits to ancient temples, rice terraces, art villages, and traditional markets in the heart of Ubud.',
                'duration' => '10 Hours',
                'price' => 450000,
                'price_motor' => 350000,
                'main_image' => 'https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=800',
                'images' => [
                    'https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=800',
                    'https://images.unsplash.com/photo-1558005530-a7958896ec60?w=800',
                ],
                'category' => 'Culture',
                'difficulty' => 'Easy',
                'max_people' => 6,
                'highlights' => ['Tegallalang Rice Terrace', 'Ubud Monkey Forest', 'Tirta Empul Temple', 'Art Villages'],
                'includes' => ['Private transport', 'Entrance fees', 'Lunch', 'Sarong rental', 'Mineral water'],
                'excludes' => ['Personal expenses', 'Souvenirs', 'Tips'],
                'itinerary' => [
                    ['time' => '08:00', 'activity' => 'Hotel pickup'],
                    ['time' => '09:30', 'activity' => 'Tegallalang Rice Terrace'],
                    ['time' => '11:00', 'activity' => 'Tirta Empul Temple (holy water purification)'],
                    ['time' => '13:00', 'activity' => 'Lunch at Ubud restaurant'],
                    ['time' => '14:30', 'activity' => 'Ubud Monkey Forest'],
                    ['time' => '16:00', 'activity' => 'Ubud Art Market'],
                    ['time' => '18:00', 'activity' => 'Return to hotel'],
                ],
                'status' => 'active',
            ],
            [
                'name' => 'Tanah Lot Sunset Tour',
                'description' => 'Visit the iconic Tanah Lot Temple perched on a rock formation in the sea, famous for its stunning sunset views and unique architecture.',
                'duration' => '6 Hours',
                'price' => 350000,
                'price_motor' => 250000,
                'main_image' => 'https://images.unsplash.com/photo-1604999333679-b86d54738315?w=800',
                'images' => [
                    'https://images.unsplash.com/photo-1604999333679-b86d54738315?w=800',
                    'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800',
                ],
                'category' => 'Temple',
                'difficulty' => 'Easy',
                'max_people' => 8,
                'highlights' => ['Tanah Lot Temple', 'Sunset photography', 'Cultural performance', 'Local snacks'],
                'includes' => ['Transport', 'Entrance fees', 'Sarong rental', 'Mineral water'],
                'excludes' => ['Personal expenses', 'Dinner', 'Tips'],
                'itinerary' => [
                    ['time' => '14:00', 'activity' => 'Hotel pickup'],
                    ['time' => '15:30', 'activity' => 'Arrive at Tanah Lot'],
                    ['time' => '16:00', 'activity' => 'Explore temple complex'],
                    ['time' => '17:30', 'activity' => 'Sunset viewing'],
                    ['time' => '19:00', 'activity' => 'Return to hotel'],
                ],
                'status' => 'active',
            ],
            [
                'name' => 'Bali Water Sports Adventure',
                'description' => 'Experience thrilling water sports activities at Tanjung Benoa Beach including jet ski, parasailing, banana boat, and snorkeling.',
                'duration' => '5 Hours',
                'price' => 750000,
                'price_motor' => 600000,
                'main_image' => 'https://images.unsplash.com/photo-1544551763-46a013bb70d5?w=800',
                'images' => [
                    'https://images.unsplash.com/photo-1544551763-46a013bb70d5?w=800',
                    'https://images.unsplash.com/photo-1530866495561-507c9daab72?w=800',
                ],
                'category' => 'Adventure',
                'difficulty' => 'Medium',
                'max_people' => 6,
                'highlights' => ['Jet Ski', 'Parasailing', 'Banana Boat', 'Snorkeling'],
                'includes' => ['Transport', 'All water sports activities', 'Safety equipment', 'Insurance', 'Mineral water'],
                'excludes' => ['Personal expenses', 'Lunch', 'Tips', 'Photo/video packages'],
                'itinerary' => [
                    ['time' => '09:00', 'activity' => 'Hotel pickup'],
                    ['time' => '10:00', 'activity' => 'Arrive at Tanjung Benoa Beach'],
                    ['time' => '10:30', 'activity' => 'Safety briefing & equipment'],
                    ['time' => '11:00', 'activity' => 'Water sports activities'],
                    ['time' => '13:30', 'activity' => 'Return to hotel'],
                ],
                'status' => 'active',
            ],
        ];

        foreach ($tours as $tourData) {
            Tour::updateOrCreate(
                ['name' => $tourData['name']],
                $tourData
            );
        }
    }
}
