@php
    $settings = \App\Models\Setting::pluck('value', 'key');
    $serviceAreas = ["Kuta", "Seminyak", "Legian", "Canggu", "Jimbaran", "Nusa Dua"];
@endphp

<footer class="bg-[#152C40] text-white mt-auto">
    <div class="container mx-auto px-6 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
            {{-- Brand --}}
            <div class="space-y-5">
                <div class="flex items-center space-x-3">
                    @if(!empty($settings['brand_logo']))
                        <img src="{{ $settings['brand_logo'] }}" alt="{{ $settings['business_name'] ?? 'Logo' }}" class="h-12 w-auto object-contain">
                    @else
                        <div class="flex items-center justify-center w-12 h-12 rounded-lg bg-[#dc8034] text-white font-bold text-xl">M</div>
                    @endif
                    <h2 class="text-2xl font-bold">{{ $settings['business_name'] ?? 'Memet Rental' }}</h2>
                </div>
                <p class="text-neutral-400 text-sm leading-relaxed">
                    Your trusted partner for vehicle rental in Bali. Best prices, well-maintained fleet, and 24/7 support.
                </p>
            </div>

            {{-- Quick Links --}}
            <div class="space-y-5">
                <h3 class="font-semibold text-base">Quick Links</h3>
                <ul class="space-y-2">
                    <li><a href="{{ route('home') }}" class="text-neutral-400 hover:text-white transition-colors duration-200 text-sm">Home</a></li>
                    @if($settings['enable_cars'] ?? 1)
                    <li><a href="{{ route('cars.index') }}" class="text-neutral-400 hover:text-white transition-colors duration-200 text-sm">Cars</a></li>
                    @endif
                    @if($settings['enable_motors'] ?? 1)
                    <li><a href="{{ route('motors.index') }}" class="text-neutral-400 hover:text-white transition-colors duration-200 text-sm">Motorbikes</a></li>
                    @endif
                     @if($settings['enable_tours'] ?? 1)
                    <li><a href="{{ route('tours.index') }}" class="text-neutral-400 hover:text-white transition-colors duration-200 text-sm">Tours</a></li>
                    @endif
                </ul>
            </div>

            {{-- Services --}}
            <div class="space-y-5">
                <h3 class="font-semibold text-base">Services</h3>
                <ul class="space-y-2">
                    <li class="text-neutral-400 text-sm">Daily Rental</li>
                    <li class="text-neutral-400 text-sm">Weekly Rental</li>
                    <li class="text-neutral-400 text-sm">Free Delivery</li>
                </ul>
            </div>

             {{-- Contact --}}
            <div class="space-y-5">
                <h3 class="font-semibold text-base">Contact</h3>
                <ul class="space-y-3">
                    <li class="flex items-start gap-3 text-neutral-400 text-sm">
                        <i class="fa-solid fa-location-dot mt-0.5"></i>
                        <span>{{ $settings['business_address'] ?? 'Jalan Raya Kuta, Bali' }}</span>
                    </li>
                    <li class="flex items-center gap-3 text-neutral-400 text-sm">
                        <i class="fa-solid fa-phone"></i>
                        <span>+{{ $settings['whatsapp_number'] ?? '6281234567890' }}</span>
                    </li>
                </ul>
            </div>
        </div>

        {{-- Service Area --}}
        <div class="mt-12 pt-8 border-t border-[#2A4560]">
             <div class="text-center mb-4">
                <p class="text-neutral-500 text-xs">Free delivery & pickup</p>
             </div>
             <div class="flex flex-wrap justify-center gap-2">
                @foreach($serviceAreas as $area)
                 <span class="px-4 py-2 bg-[#ffffff]/10 text-white rounded-full text-xs font-medium">{{ $area }}</span>
                @endforeach
             </div>
        </div>
    </div>

    <div class="border-t border-[#2A4560] bg-[#0F2030]">
        <div class="container mx-auto px-6 py-5 flex items-center justify-between">
            <p class="text-neutral-500 text-sm">© {{ date('Y') }} Memet Rental. All rights reserved.</p>
        </div>
    </div>
</footer>
