<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full bg-gray-50">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }} - Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        /* Admin layout with fixed sidebar */
        .admin-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .admin-sidebar {
            width: 256px;
            flex-shrink: 0;
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            overflow-y: auto;
        }
        .admin-main {
            flex: 1;
            margin-left: 256px;
            min-height: 100vh;
        }
        @media (max-width: 768px) {
            .admin-sidebar {
                transform: translateX(-100%);
                z-index: 40;
            }
            .admin-sidebar.open {
                transform: translateX(0);
            }
            .admin-main {
                margin-left: 0;
            }
        }
    </style>
</head>
<body class="h-full font-sans antialiased text-gray-900" x-data="{ sidebarOpen: false }">
    
    {{-- Sidebar Backdrop (Mobile) --}}
    <div x-show="sidebarOpen" @click="sidebarOpen = false" class="fixed inset-0 z-30 bg-black/50 md:hidden" style="display: none;"></div>
    
    {{-- Sidebar --}}
    <aside 
        :class="sidebarOpen ? 'open' : ''"
        class="admin-sidebar bg-[#1e293b] text-white flex flex-col"
    >
        <div class="flex items-center justify-center h-16 bg-[#0f172a] shadow-sm shrink-0">
             <h1 class="text-xl font-bold tracking-tight">Memet Admin</h1>
        </div>

        <nav class="flex-1 overflow-y-auto py-4 px-3 space-y-1">
            <x-admin-sidebar />
        </nav>

        <div class="p-4 border-t border-slate-700 bg-[#0f172a] shrink-0">
            <div class="flex items-center gap-3">
                <div class="h-9 w-9 rounded-full bg-slate-600 flex items-center justify-center text-sm font-bold">
                    {{ substr(auth()->user()->name, 0, 1) }}
                </div>
                <div class="overflow-hidden">
                    <p class="text-sm font-medium truncate">{{ auth()->user()->name }}</p>
                    <p class="text-xs text-slate-400 capitalize">{{ auth()->user()->role }}</p>
                </div>
            </div>
            <form method="POST" action="{{ route('logout') }}" class="mt-3">
                @csrf
                <button type="submit" class="w-full flex items-center justify-center px-4 py-2 text-sm text-slate-300 hover:text-white hover:bg-slate-700 rounded-md transition-colors">
                    <i class="fa-solid fa-right-from-bracket mr-2"></i>
                    Sign Out
                </button>
            </form>
        </div>
    </aside>

    {{-- Main Content Area --}}
    <div class="admin-main flex flex-col">
        {{-- Mobile Header --}}
        <div class="md:hidden flex items-center justify-between bg-white border-b px-4 py-3 sticky top-0 z-20 shrink-0">
            <div class="flex items-center gap-2">
                <img src="https://ui-avatars.com/api/?name=Memet+Rental&background=dc8034&color=fff" alt="Logo" class="h-8 w-8 rounded bg-gray-100">
                <span class="font-bold text-gray-800">Admin Panel</span>
            </div>
            <button @click="sidebarOpen = !sidebarOpen" class="text-gray-500 hover:text-gray-700">
                <i class="fa-solid fa-bars text-xl"></i>
            </button>
        </div>

        {{-- Main Content --}}
        <main class="flex-1 bg-gray-50 p-4 md:p-8 overflow-auto">
            <div class="max-w-7xl mx-auto">
                 {{ $slot }}
            </div>
        </main>
    </div>
</body>
</html>
