<div class="max-w-4xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-2xl font-bold tracking-tight text-slate-800">Edit Article</h2>
        <a href="{{ route('admin.articles.index') }}" class="px-4 py-2 bg-white text-slate-700 font-medium rounded-lg border border-slate-300 hover:bg-slate-50 transition-colors">
            <i class="fa-solid fa-arrow-left mr-2"></i> Back
        </a>
    </div>

    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <form wire:submit="save" class="p-6 space-y-6">
            {{-- Title --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Title</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none text-slate-400">
                        <i class="fa-solid fa-heading"></i>
                    </div>
                    <input type="text" wire:model="title" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="Article Title">
                </div>
                @error('title') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Content --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Description / Content</label>
                <textarea wire:model="content" rows="10" class="block w-full rounded-lg border-0 py-2.5 px-3 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="Write your article content here..."></textarea>
                @error('content') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Image --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Cover Image (Optional)</label>
                
                {{-- Current Image Preview --}}
                @if($image && !$new_image)
                    <div class="mb-4">
                        <p class="text-xs text-slate-500 mb-2">Current Image:</p>
                        <img src="{{ asset('storage/' . $image) }}" class="h-48 object-cover rounded-lg border border-slate-200">
                    </div>
                @endif

                <div class="mt-2 flex justify-center rounded-lg border border-dashed border-slate-300 px-6 py-10 hover:bg-slate-50 transition-colors relative">
                    <div class="text-center">
                        @if ($new_image)
                            <img src="{{ $new_image->temporaryUrl() }}" class="mx-auto h-48 object-cover rounded-lg mb-4">
                        @else
                            <div class="mx-auto h-12 w-12 text-slate-300">
                                <i class="fa-solid fa-image text-4xl"></i>
                            </div>
                        @endif
                        
                        <div class="mt-4 flex text-sm leading-6 text-slate-600 justify-center">
                            <label for="file-upload" class="relative cursor-pointer rounded-md bg-white font-semibold text-[#dc8034] focus-within:outline-none focus-within:ring-2 focus-within:ring-[#dc8034] focus-within:ring-offset-2 hover:text-[#c06d28]">
                                <span>Upload a new file</span>
                                <input id="file-upload" wire:model="new_image" type="file" class="sr-only">
                            </label>
                            <p class="pl-1">or drag and drop</p>
                        </div>
                        <p class="text-xs leading-5 text-slate-500">PNG, JPG, GIF up to 2MB</p>
                    </div>

                    {{-- Loading State --}}
                    <div wire:loading wire:target="new_image" class="absolute inset-0 bg-white/80 flex flex-col items-center justify-center rounded-lg z-10 transition-opacity">
                        <i class="fa-solid fa-circle-notch fa-spin text-3xl text-[#dc8034] mb-2"></i>
                        <p class="text-sm font-semibold text-[#dc8034]">Uploading...</p>
                    </div>
                </div>
                @error('new_image') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Status --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1">Status</label>
                <select wire:model="status" class="block w-full rounded-lg border-0 py-2.5 px-3 text-slate-900 ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                    <option value="published">Published</option>
                    <option value="draft">Draft</option>
                </select>
                @error('status') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Submit --}}
            <div class="flex justify-end pt-4">
                <button type="submit" class="px-6 py-2.5 bg-[#dc8034] text-white font-semibold rounded-lg hover:bg-[#c06d28] transition-colors shadow-lg shadow-[#dc8034]/20 flex items-center">
                    <i class="fa-solid fa-save mr-2"></i> Update Article
                </button>
            </div>
        </form>
    </div>
</div>
