<div class="space-y-6">
    {{-- Header --}}
    <div class="flex items-center justify-between">
        <h2 class="text-2xl font-bold tracking-tight text-slate-800">Brands Management</h2>
        <button wire:click="create" class="px-4 py-2 bg-[#dc8034] text-white font-semibold rounded-lg hover:bg-[#c06d28] transition-colors shadow-lg shadow-[#dc8034]/20">
            <i class="fa-solid fa-plus mr-2"></i> Add Brand
        </button>
    </div>

    {{-- Tabs --}}
    <div class="border-b border-slate-200">
        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
            <button 
                wire:click="switchTab('cars')"
                class="{{ $activeTab === 'cars' ? 'border-[#dc8034] text-[#dc8034]' : 'border-transparent text-slate-500 hover:text-slate-700 hover:border-slate-300' }} whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors"
            >
                <i class="fa-solid fa-car mr-2"></i> Car Brands
            </button>
            <button 
                wire:click="switchTab('motors')"
                class="{{ $activeTab === 'motors' ? 'border-[#dc8034] text-[#dc8034]' : 'border-transparent text-slate-500 hover:text-slate-700 hover:border-slate-300' }} whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors"
            >
                <i class="fa-solid fa-motorcycle mr-2"></i> Motor Brands
            </button>
        </nav>
    </div>

    {{-- Content --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Logo</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Name</th>
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-slate-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    @forelse($brands as $brand)
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($brand->logo)
                                    <img src="{{ asset('storage/' . $brand->logo) }}" class="h-10 w-10 rounded-full object-cover border border-slate-200">
                                @else
                                    <div class="h-10 w-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-400">
                                        <i class="fa-solid fa-image"></i>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-slate-900">
                                {{ $brand->name }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <button wire:click="edit({{ $brand->id }})" class="text-blue-600 hover:text-blue-900 mr-3">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </button>
                                <button wire:click="delete({{ $brand->id }})" wire:confirm="Are you sure you want to delete this brand?" class="text-red-500 hover:text-red-700">
                                    <i class="fa-solid fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="px-6 py-12 text-center text-slate-500">
                                <i class="fa-solid fa-folder-open text-4xl mb-3 text-slate-300"></i>
                                <p>No brands found. Click "Add Brand" to create one.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- Modal --}}
    @if($showModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-slate-900/75 transition-opacity" aria-hidden="true" wire:click="$set('showModal', false)"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-bottom bg-white rounded-xl text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                    <form wire:submit="save">
                        <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                            <div class="sm:flex sm:items-start">
                                <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                    <h3 class="text-lg leading-6 font-medium text-slate-900" id="modal-title">
                                        {{ $isEditing ? 'Edit Brand' : 'Add New Brand' }} ({{ ucfirst($activeTab) }})
                                    </h3>
                                    <div class="mt-4 space-y-4">
                                        <div>
                                            <label class="block text-sm font-medium text-slate-700 mb-1">Brand Name</label>
                                            <input type="text" wire:model="name" class="w-full rounded-lg border-slate-300 focus:ring-[#dc8034] focus:border-[#dc8034]" placeholder="e.g. Toyota">
                                            @error('name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-slate-700 mb-1">Logo (Optional)</label>
                                            <div class="flex items-center gap-4">
                                                <div class="relative h-12 w-12">
                                                    @if($temp_logo)
                                                        <img src="{{ $temp_logo->temporaryUrl() }}" class="h-12 w-12 rounded-full object-cover border">
                                                    @elseif($logo)
                                                        <img src="{{ asset('storage/' . $logo) }}" class="h-12 w-12 rounded-full object-cover border">
                                                    @else
                                                        <div class="h-12 w-12 rounded-full bg-slate-100 flex items-center justify-center text-slate-400 border border-dashed border-slate-300">
                                                            <i class="fa-solid fa-image"></i>
                                                        </div>
                                                    @endif

                                                    {{-- Loading State --}}
                                                    <div wire:loading wire:target="temp_logo" class="absolute inset-0 bg-white/80 flex items-center justify-center rounded-full border border-slate-200 z-10">
                                                        <i class="fa-solid fa-circle-notch fa-spin text-[#dc8034]"></i>
                                                    </div>
                                                </div>
                                                <input type="file" wire:model="temp_logo" class="text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-[#dc8034]/10 file:text-[#dc8034] hover:file:bg-[#dc8034]/20">
                                            </div>
                                            @error('temp_logo') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                            <button type="submit" class="w-full inline-flex justify-center rounded-lg border border-transparent shadow-sm px-4 py-2 bg-[#dc8034] text-base font-medium text-white hover:bg-[#c06d28] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#dc8034] sm:ml-3 sm:w-auto sm:text-sm">
                                Save Brand
                            </button>
                            <button type="button" wire:click="$set('showModal', false)" class="mt-3 w-full inline-flex justify-center rounded-lg border border-slate-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-slate-700 hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#dc8034] sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>
