<div class="space-y-6">
    <div class="flex items-center justify-between">
        <h2 class="text-2xl font-bold tracking-tight text-slate-800">Dashboard</h2>
        <div class="flex items-center space-x-2">
            <span class="px-3 py-1 text-xs font-semibold text-emerald-700 bg-emerald-100 rounded-full">
                System Operational
            </span>
        </div>
    </div>

    {{-- Analytics Grid --}}
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 md:gap-4">
        {{-- Leads Today --}}
        <div class="bg-white p-4 md:p-6 rounded-xl border border-slate-200 shadow-sm flex flex-col justify-between relative overflow-hidden">
            <div>
                <p class="text-[10px] md:text-xs font-medium text-slate-500 uppercase tracking-wider">Leads Today</p>
                <div class="flex items-baseline gap-2 mt-1">
                    <p class="text-2xl md:text-3xl font-bold text-slate-800">{{ $stats['leads_today'] }}</p>
                    <span class="text-xs text-slate-500">requests</span>
                </div>
            </div>
            <div class="absolute right-[-10px] bottom-[-10px] opacity-10">
                <i class="fa-solid fa-file-signature text-6xl text-[#dc8034]"></i>
            </div>
        </div>

        {{-- WA Clicks Today --}}
        <div class="bg-white p-4 md:p-6 rounded-xl border border-slate-200 shadow-sm flex flex-col justify-between relative overflow-hidden">
            <div>
                <p class="text-[10px] md:text-xs font-medium text-slate-500 uppercase tracking-wider">WA Clicks Today</p>
                <div class="flex items-baseline gap-2 mt-1">
                    <p class="text-2xl md:text-3xl font-bold text-slate-800">{{ $stats['clicks_today'] }}</p>
                    <span class="text-xs text-slate-500">clicks</span>
                </div>
            </div>
            <div class="absolute right-[-10px] bottom-[-10px] opacity-10">
                <i class="fa-brands fa-whatsapp text-6xl text-emerald-600"></i>
            </div>
        </div>

        {{-- Car Fleet --}}
        <div class="bg-white p-4 md:p-6 rounded-xl border border-slate-200 shadow-sm overflow-hidden">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <p class="text-[10px] md:text-xs font-medium text-slate-500 uppercase tracking-wider">Cars</p>
                    <p class="text-xl font-bold text-slate-800">{{ $carStats['total'] }} <span class="text-xs font-normal text-slate-500">Total</span></p>
                </div>
                <div class="p-2 bg-blue-50 rounded-lg">
                    <i class="fa-solid fa-car text-blue-600"></i>
                </div>
            </div>
            <div class="grid grid-cols-3 gap-2 text-center">
                <div class="bg-emerald-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-emerald-700">{{ $carStats['available'] }}</span>
                    <span class="block text-[10px] text-emerald-600/80">Ready</span>
                </div>
                <div class="bg-amber-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-amber-700">{{ $carStats['booked'] }}</span>
                    <span class="block text-[10px] text-amber-600/80">Booked</span>
                </div>
                <div class="bg-red-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-red-700">{{ $carStats['maintenance'] }}</span>
                    <span class="block text-[10px] text-red-600/80">Service</span>
                </div>
            </div>
        </div>

        {{-- Motor Fleet --}}
        <div class="bg-white p-4 md:p-6 rounded-xl border border-slate-200 shadow-sm overflow-hidden">
             <div class="flex items-center justify-between mb-4">
                <div>
                    <p class="text-[10px] md:text-xs font-medium text-slate-500 uppercase tracking-wider">Motorbikes</p>
                    <p class="text-xl font-bold text-slate-800">{{ $motorStats['total'] }} <span class="text-xs font-normal text-slate-500">Total</span></p>
                </div>
                <div class="p-2 bg-orange-50 rounded-lg">
                    <i class="fa-solid fa-motorcycle text-orange-600"></i>
                </div>
            </div>
            <div class="grid grid-cols-3 gap-2 text-center">
                <div class="bg-emerald-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-emerald-700">{{ $motorStats['available'] }}</span>
                    <span class="block text-[10px] text-emerald-600/80">Ready</span>
                </div>
                <div class="bg-amber-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-amber-700">{{ $motorStats['booked'] }}</span>
                    <span class="block text-[10px] text-amber-600/80">Booked</span>
                </div>
                <div class="bg-red-50 rounded-lg py-2">
                    <span class="block text-xs font-bold text-red-700">{{ $motorStats['maintenance'] }}</span>
                    <span class="block text-[10px] text-red-600/80">Service</span>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Recent Activity --}}
        <div class="lg:col-span-2 bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
            <div class="p-6 border-b border-slate-100 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800">Recent Activity</h3>
                <span class="text-xs text-slate-500">Real-time logs</span>
            </div>
            <div class="divide-y divide-slate-100">
                @forelse($recentActivity as $log)
                <div class="p-4 flex items-start gap-4 hover:bg-slate-50 transition-colors">
                    <div class="mt-1">
                        @if($log->action == 'booking_submission')
                            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-orange-100 text-[#dc8034]">
                                <i class="fa-solid fa-file-signature text-xs"></i>
                            </span>
                        @elseif($log->action == 'whatsapp_floating')
                            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-emerald-100 text-emerald-600">
                                <i class="fa-brands fa-whatsapp text-xs"></i>
                            </span>
                        @else
                            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-slate-100 text-slate-500">
                                <i class="fa-solid fa-info text-xs"></i>
                            </span>
                        @endif
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-slate-800">{{ $log->description }}</p>
                         <p class="text-xs text-slate-500 truncate">
                            {{ $log->ip_address }} • {{ $log->created_at->diffForHumans() }}
                        </p>
                        @if(!empty($log->details))
                         <div class="mt-1 text-xs text-slate-600 bg-slate-50 p-2 rounded border border-slate-100">
                             @if(isset($log->details['customer_name']))
                                <strong>Customer:</strong> {{ $log->details['customer_name'] }}<br>
                             @endif
                             @if(isset($log->details['booking_date']))
                                <strong>Date:</strong> {{ \Carbon\Carbon::parse($log->details['booking_date'])->format('d M Y') }}
                             @endif
                         </div>
                        @endif
                    </div>
                </div>
                @empty
                <div class="text-center py-8 text-slate-400">
                    <i class="fa-solid fa-clock text-4xl mb-2 opacity-50"></i>
                    <p class="text-sm">No recent activity logs found.</p>
                </div>
                @endforelse
            </div>
        </div>

        {{-- Popular Items --}}
        <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden h-fit">
            <div class="p-6 border-b border-slate-100">
                <h3 class="text-lg font-bold text-slate-800">Popular Requests</h3>
            </div>
            <div class="p-4">
                @forelse($popularItems as $item)
                <div class="flex items-center justify-between mb-4 last:mb-0">
                    <div class="flex items-center gap-3">
                        <span class="text-slate-400 font-bold text-lg w-4">{{ $loop->iteration }}</span>
                        <div>
                            <p class="text-sm font-semibold text-slate-800 line-clamp-1">{{ str_replace('Booking Request for ', '', $item->description) }}</p>
                        </div>
                    </div>
                    <span class="px-2 py-1 text-xs font-bold text-slate-600 bg-slate-100 rounded-lg">
                        {{ $item->total }} requests
                    </span>
                </div>
                @empty
                 <p class="text-sm text-slate-500 text-center py-4">Not enough data.</p>
                @endforelse
            </div>
            
             <div class="p-4 bg-slate-50 border-t border-slate-100">
                <button onclick="window.location='{{ route('cars.index') }}'" class="w-full py-2 text-sm font-semibold text-[#dc8034] hover:text-[#b06629] transition-colors">
                    View Fleet Status <i class="fa-solid fa-arrow-right ml-1"></i>
                </button>
            </div>
        </div>
    </div>
</div>
