<div class="space-y-6">
    <div class="flex items-center justify-between border-b border-slate-200 pb-5">
        <div>
             <h2 class="text-2xl font-bold tracking-tight text-slate-800">System Settings</h2>
             <p class="text-sm text-slate-500 mt-1">Manage feature toggles and global configurations.</p>
        </div>
        <div>
            <span class="inline-flex items-center rounded-md bg-blue-50 px-2 py-1 text-xs font-medium text-blue-700 ring-1 ring-inset ring-blue-700/10">
                Superadmin Area
            </span>
        </div>
    </div>

    {{-- Feature Toggles --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="col-span-1 md:col-span-3">
            <h3 class="text-base font-semibold text-slate-900 mb-4">Feature Modules</h3>
        </div>

        @foreach(['enable_cars' => 'Car Rental Module', 'enable_motors' => 'Motorbike Rental Module', 'enable_tours' => 'Tour Packages Module'] as $key => $label)
            <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm flex items-center justify-between">
                <div>
                     <p class="font-medium text-slate-800">{{ $label }}</p>
                     <p class="text-xs text-slate-500 mt-1">
                         {{ $settings[$key] == '1' ? 'Currently Active' : 'Currently Disabled' }}
                     </p>
                </div>
                
                <button 
                    wire:click="toggle('{{ $key }}')"
                    class="relative inline-flex h-6 w-11 shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-[#dc8034] focus:ring-offset-2 {{ $settings[$key] == '1' ? 'bg-[#dc8034]' : 'bg-slate-200' }}"
                >
                    <span class="sr-only">Use setting</span>
                    <span 
                        aria-hidden="true" 
                        class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $settings[$key] == '1' ? 'translate-x-5' : 'translate-x-0' }}"
                    ></span>
                </button>
            </div>
        @endforeach
    </div>

    {{-- General Settings --}}
    
    {{-- Branding & Appearance --}}
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
        {{-- Logo Upload --}}
        <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden flex flex-col h-full">
            <div class="p-5 border-b border-slate-100 bg-slate-50/50">
                 <h3 class="font-semibold text-slate-900">Brand Logo</h3>
                 <p class="text-xs text-slate-500 mt-1">Upload your business logo here.</p>
            </div>
            <div class="p-6 flex flex-col justify-center grow">
                <div class="flex flex-col items-center">
                    <div class="relative group w-full max-w-sm aspect-video bg-slate-50 rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer overflow-hidden">
                        @if(isset($settings['brand_logo']))
                            <img src="{{ $settings['brand_logo'] }}" class="absolute inset-0 w-full h-full object-contain p-4 z-10">
                            <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity z-20 flex items-center justify-center">
                                <span class="text-white font-medium text-sm">Click to Change</span>
                            </div>
                        @else
                            <div class="flex flex-col items-center justify-center p-6 text-center z-10">
                                <div class="w-12 h-12 rounded-full bg-slate-100 flex items-center justify-center mb-3">
                                    <i class="fa-solid fa-cloud-arrow-up text-slate-400 text-xl group-hover:text-[#dc8034] transition-colors"></i>
                                </div>
                                <p class="text-sm font-medium text-slate-700">Click to upload logo</p>
                                <p class="text-xs text-slate-500 mt-1">PNG, JPG up to 1MB</p>
                            </div>
                        @endif
                        
                        <input type="file" wire:model="brand_logo" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-30">
                        
                         {{-- Loading --}}
                        <div wire:loading wire:target="brand_logo" class="absolute inset-0 bg-white/90 z-40 flex items-center justify-center">
                            <div class="flex flex-col items-center">
                                <i class="fa-solid fa-spinner fa-spin text-2xl text-[#dc8034] mb-2"></i>
                                <span class="text-xs font-semibold text-[#dc8034]">Uploading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Hero Slideshow --}}
        @php
            $heroSlides = json_decode($settings['hero_slides'] ?? '[]', true);
            $slideCount = count($heroSlides);
            $maxSlides = 5;
            $availableSlots = $maxSlides - $slideCount;
            $progressPercent = ($slideCount / $maxSlides) * 100;
        @endphp
        <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden flex flex-col">
            <div class="p-5 border-b border-slate-100 bg-slate-50/50">
                 <div class="flex justify-between items-start">
                    <div>
                        <h3 class="font-semibold text-slate-900">Hero Slideshow</h3>
                        <p class="text-xs text-slate-500 mt-1">Max 5 images. 16:9 Aspect ratio recommended.</p>
                    </div>
                    <div class="flex flex-col items-end gap-1">
                        <span class="text-sm font-bold {{ $slideCount >= $maxSlides ? 'text-red-600' : 'text-slate-600' }}">
                            {{ $slideCount }} / {{ $maxSlides }}
                        </span>
                        {{-- Progress Bar --}}
                        <div class="w-24 h-1.5 bg-slate-200 rounded-full overflow-hidden">
                            <div class="h-full rounded-full transition-all duration-300 {{ $slideCount >= $maxSlides ? 'bg-red-500' : ($slideCount >= 3 ? 'bg-amber-500' : 'bg-[#dc8034]') }}" 
                                 style="width: {{ $progressPercent }}%"></div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="p-6 space-y-4">
                {{-- Flash Messages --}}
                @if(session('hero_success'))
                    <div class="p-3 bg-green-50 border border-green-200 rounded-lg flex items-center gap-2 text-green-700 text-sm">
                        <i class="fa-solid fa-check-circle"></i>
                        {{ session('hero_success') }}
                    </div>
                @endif
                @if(session('hero_warning'))
                    <div class="p-3 bg-amber-50 border border-amber-200 rounded-lg flex items-center gap-2 text-amber-700 text-sm">
                        <i class="fa-solid fa-exclamation-triangle"></i>
                        {{ session('hero_warning') }}
                    </div>
                @endif
                @if(session('hero_error'))
                    <div class="p-3 bg-red-50 border border-red-200 rounded-lg flex items-center gap-2 text-red-700 text-sm">
                        <i class="fa-solid fa-circle-xmark"></i>
                        {{ session('hero_error') }}
                    </div>
                @endif
                @error('hero_slides.*')
                    <div class="p-3 bg-red-50 border border-red-200 rounded-lg flex items-center gap-2 text-red-700 text-sm">
                        <i class="fa-solid fa-circle-xmark"></i>
                        {{ $message }}
                    </div>
                @enderror

                 {{-- Upload Area --}}
                 @if($availableSlots > 0)
                    <div 
                        class="relative group w-full min-h-[140px] bg-linear-to-b from-slate-50 to-white rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer"
                        x-data="{ dragOver: false }"
                        x-on:dragover.prevent="dragOver = true"
                        x-on:dragleave.prevent="dragOver = false"
                        x-on:drop.prevent="dragOver = false"
                        :class="{ 'border-[#dc8034] bg-[#dc8034]/10 scale-[1.02]': dragOver }"
                    >
                        <div class="flex flex-col items-center justify-center text-center p-6">
                            <div class="w-14 h-14 rounded-full bg-slate-100 group-hover:bg-[#dc8034]/20 flex items-center justify-center mb-3 transition-colors">
                                <i class="fa-solid fa-cloud-arrow-up text-slate-400 text-2xl group-hover:text-[#dc8034] transition-colors"></i>
                            </div>
                            <p class="text-sm font-medium text-slate-700">Drop images here or click to upload</p>
                            <p class="text-xs text-slate-500 mt-1">{{ $availableSlots }} slot(s) available • PNG, JPG up to 15MB each</p>
                        </div>
                        <input type="file" wire:model="hero_slides" multiple accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                        
                        {{-- Loading Overlay --}}
                        <div wire:loading wire:target="hero_slides" class="absolute inset-0 bg-white/95 flex flex-col items-center justify-center rounded-xl z-10">
                            <div class="w-12 h-12 mb-3 relative">
                                <div class="absolute inset-0 rounded-full border-4 border-slate-200"></div>
                                <div class="absolute inset-0 rounded-full border-4 border-[#dc8034] border-t-transparent animate-spin"></div>
                            </div>
                            <span class="text-sm font-semibold text-[#dc8034]">Uploading images...</span>
                            <span class="text-xs text-slate-500 mt-1">Please wait</span>
                        </div>
                    </div>
                @else
                    <div class="w-full p-4 bg-slate-100 rounded-xl border border-slate-200 text-center">
                        <i class="fa-solid fa-circle-check text-slate-400 mb-2"></i>
                        <p class="text-sm text-slate-600 font-medium">Maximum slides reached</p>
                        <p class="text-xs text-slate-500 mt-1">Remove a slide to add more</p>
                    </div>
                @endif

                 {{-- Slides List --}}
                 @if($slideCount > 0)
                    <div class="space-y-3">
                        <div class="flex items-center justify-between">
                            <h4 class="text-sm font-medium text-slate-700">Current Slides</h4>
                            <span class="text-xs text-slate-500">Drag to reorder (coming soon)</span>
                        </div>
                        <div class="space-y-3 max-h-[400px] overflow-y-auto pr-1">
                            @foreach($heroSlides as $index => $slide)
                                <div class="flex items-stretch gap-3 p-2 bg-white border border-slate-200 rounded-lg shadow-sm group hover:border-[#dc8034]/30 hover:shadow-md transition-all">
                                    {{-- Thumbnail --}}
                                    <div class="w-20 aspect-video bg-slate-100 rounded-md overflow-hidden shrink-0 relative">
                                        <img src="{{ $slide['image'] }}" class="w-full h-full object-cover" alt="Slide {{ $index + 1 }}">
                                        <div class="absolute top-0.5 left-0.5 bg-black/60 text-white text-[9px] font-bold px-1 py-0.5 rounded">
                                            #{{ $index + 1 }}
                                        </div>
                                    </div>
                                    
                                    {{-- Content --}}
                                    <div class="flex-1 min-w-0 flex flex-col justify-center gap-1.5">
                                        <input 
                                            type="text" 
                                            value="{{ $slide['title'] ?? 'Explore Bali' }}"
                                            wire:blur="updateSlideText({{ $index }}, 'title', $event.target.value)"
                                            class="text-sm font-medium text-slate-800 bg-transparent border-0 border-b border-transparent hover:border-slate-200 focus:border-[#dc8034] focus:ring-0 px-0 py-0.5 transition-colors"
                                            placeholder="Slide title..."
                                        >
                                        <input 
                                            type="text" 
                                            value="{{ $slide['subtitle'] ?? 'Premium Vehicles for Rent' }}"
                                            wire:blur="updateSlideText({{ $index }}, 'subtitle', $event.target.value)"
                                            class="text-xs text-slate-500 bg-transparent border-0 border-b border-transparent hover:border-slate-200 focus:border-[#dc8034] focus:ring-0 px-0 py-0.5 transition-colors"
                                            placeholder="Slide subtitle..."
                                        >
                                    </div>
                                    
                                    {{-- Actions --}}
                                    <div class="flex flex-col justify-center gap-1">
                                        @if($index > 0)
                                            <button 
                                                wire:click="moveSlide({{ $index }}, 'up')" 
                                                class="p-1.5 text-slate-400 hover:text-[#dc8034] hover:bg-[#dc8034]/10 rounded transition-all"
                                                title="Move up"
                                            >
                                                <i class="fa-solid fa-chevron-up text-xs"></i>
                                            </button>
                                        @else
                                            <div class="p-1.5 opacity-0"><i class="fa-solid fa-chevron-up text-xs"></i></div>
                                        @endif
                                        @if($index < $slideCount - 1)
                                            <button 
                                                wire:click="moveSlide({{ $index }}, 'down')" 
                                                class="p-1.5 text-slate-400 hover:text-[#dc8034] hover:bg-[#dc8034]/10 rounded transition-all"
                                                title="Move down"
                                            >
                                                <i class="fa-solid fa-chevron-down text-xs"></i>
                                            </button>
                                        @else
                                            <div class="p-1.5 opacity-0"><i class="fa-solid fa-chevron-down text-xs"></i></div>
                                        @endif
                                        <button 
                                            wire:click="removeSlide({{ $index }})" 
                                            wire:confirm="Are you sure you want to delete this slide?"
                                            class="p-1.5 text-slate-400 hover:text-red-500 hover:bg-red-50 rounded transition-all"
                                            title="Delete slide"
                                        >
                                            <i class="fa-solid fa-trash-can text-xs"></i>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="text-center py-8 text-slate-400">
                        <i class="fa-solid fa-images text-4xl mb-3 opacity-50"></i>
                        <p class="text-sm">No slides added yet</p>
                        <p class="text-xs mt-1">Upload images to create your hero slideshow</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- General Information --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm mt-8 overflow-hidden">
        <div class="p-6 border-b border-slate-100 bg-slate-50/50">
             <h3 class="font-semibold text-slate-900">General Information</h3>
        </div>
        <div class="p-6 space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Business Name --}}
                <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Business Name</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-building text-slate-400"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['business_name'] ?? '' }}"
                            wire:blur="updateSetting('business_name', $event.target.value)"
                            placeholder="e.g. Memet Rental Bali"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                    <p class="mt-1.5 text-xs text-slate-500">Your specific business brand name.</p>
                </div>

                {{-- WhatsApp Number --}}
                 <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">WhatsApp Number</label>
                     <div class="relative">
                        <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                            <i class="fa-brands fa-whatsapp text-slate-400 text-lg"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['whatsapp_number'] ?? '' }}"
                            wire:blur="updateSetting('whatsapp_number', $event.target.value)"
                            placeholder="6281234567890"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                    <p class="mt-1.5 text-xs text-slate-500">Format: 6281xxxxxx (Start with country code, no +)</p>
                </div>

                {{-- Address --}}
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Address</label>
                    <div class="relative">
                         <div class="absolute top-3 left-3 pointer-events-none">
                            <i class="fa-solid fa-map-location-dot text-slate-400"></i>
                        </div>
                        <textarea 
                            wire:blur="updateSetting('address', $event.target.value)"
                            rows="3"
                            placeholder="Full business address..."
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >{{ $settings['address'] ?? '' }}</textarea>
                    </div>
                    <p class="mt-1.5 text-xs text-slate-500">This address will appear in the footer.</p>
                </div>
            </div>
        </div>
    </div>

    {{-- Social Media --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm mt-8 overflow-hidden">
        <div class="p-6 border-b border-slate-100 bg-slate-50/50">
             <h3 class="font-semibold text-slate-900">Social Media</h3>
             <p class="text-xs text-slate-500 mt-1">Links to your social media profiles.</p>
        </div>
        <div class="p-6 space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                 {{-- Instagram --}}
                <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Instagram URL</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-brands fa-instagram text-slate-400 text-lg"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['instagram_url'] ?? '' }}"
                            wire:blur="updateSetting('instagram_url', $event.target.value)"
                            placeholder="https://instagram.com/username"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                </div>

                {{-- Facebook --}}
                <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Facebook URL</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-brands fa-facebook text-slate-400 text-lg"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['facebook_url'] ?? '' }}"
                            wire:blur="updateSetting('facebook_url', $event.target.value)"
                            placeholder="https://facebook.com/username"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                </div>

                {{-- Telegram --}}
                <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Telegram URL</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-brands fa-telegram text-slate-400 text-lg"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['telegram_url'] ?? '' }}"
                            wire:blur="updateSetting('telegram_url', $event.target.value)"
                            placeholder="https://t.me/username"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                </div>

                {{-- WhatsApp (for reference, already displayed in General Info) --}}
                <div class="col-span-1">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">TikTok URL</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-brands fa-tiktok text-slate-400 text-lg"></i>
                        </div>
                        <input 
                            type="text" 
                            value="{{ $settings['tiktok_url'] ?? '' }}"
                            wire:blur="updateSetting('tiktok_url', $event.target.value)"
                            placeholder="https://tiktok.com/@username"
                            class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                        >
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Snippet Code / Tracking --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm mt-8 overflow-hidden">
        <div class="p-6 border-b border-slate-100 bg-slate-50/50 flex items-center gap-3">
            <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center">
                <i class="fa-solid fa-code text-blue-600"></i>
            </div>
            <div>
                <h3 class="font-semibold text-slate-900">Snippet Code / Tracking</h3>
                <p class="text-xs text-slate-500">Google Tag Manager dan kode tracking lainnya</p>
            </div>
        </div>
        <div class="p-6 space-y-6">
            {{-- GTM ID --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Google Tag Manager ID</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <i class="fa-solid fa-tag text-slate-400"></i>
                    </div>
                    <input 
                        type="text" 
                        value="{{ $settings['gtm_id'] ?? '' }}"
                        wire:blur="updateSetting('gtm_id', $event.target.value)"
                        placeholder="GTM-XXXXXXX"
                        class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6"
                    >
                </div>
                <p class="mt-1.5 text-xs text-slate-500">Masukkan ID Google Tag Manager Anda (contoh: GTM-ABC123). Script GTM akan otomatis dipasang di website.</p>
            </div>

            {{-- GTM Instructions --}}
            <div class="p-4 bg-blue-50 rounded-lg border border-blue-100">
                <h4 class="font-medium text-blue-900 mb-2 text-sm">Cara mendapatkan GTM ID:</h4>
                <ol class="text-sm text-blue-700 space-y-1 list-decimal list-inside">
                    <li>Buka <a href="https://tagmanager.google.com" target="_blank" rel="noopener noreferrer" class="underline hover:text-blue-900">tagmanager.google.com</a></li>
                    <li>Buat container baru atau pilih yang sudah ada</li>
                    <li>Salin ID yang dimulai dengan GTM-</li>
                    <li>Paste di kolom di atas</li>
                </ol>
            </div>

            {{-- Custom Head Script --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Custom Head Script (Opsional)</label>
                <textarea 
                    wire:blur="updateSetting('head_script', $event.target.value)"
                    rows="4"
                    placeholder="<!-- Paste script tambahan di sini -->"
                    class="block w-full rounded-lg border-0 py-2.5 px-3 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6 font-mono text-xs"
                >{{ $settings['head_script'] ?? '' }}</textarea>
                <p class="mt-1.5 text-xs text-slate-500">Script tambahan yang akan dipasang di bagian &lt;head&gt; (contoh: Facebook Pixel, Google Analytics, dll)</p>
            </div>

            {{-- Custom Body Script --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Custom Body Script (Opsional)</label>
                <textarea 
                    wire:blur="updateSetting('body_script', $event.target.value)"
                    rows="4"
                    placeholder="<!-- Paste script tambahan di sini -->"
                    class="block w-full rounded-lg border-0 py-2.5 px-3 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6 font-mono text-xs"
                >{{ $settings['body_script'] ?? '' }}</textarea>
                <p class="mt-1.5 text-xs text-slate-500">Script tambahan yang akan dipasang setelah &lt;body&gt;</p>
            </div>
        </div>
    </div>
</div>
