<div class="space-y-6">
    {{-- Header --}}
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold tracking-tight text-slate-800">Edit User</h2>
            <p class="text-sm text-slate-500 mt-1">Update user account details.</p>
        </div>
        <a href="{{ route('admin.users.index') }}" class="inline-flex items-center px-4 py-2 bg-white border border-slate-200 text-slate-700 font-semibold rounded-lg shadow-sm hover:bg-slate-50 transition-colors">
            <i class="fa-solid fa-arrow-left mr-2"></i>
            Back to Users
        </a>
    </div>

    {{-- Form --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <form wire:submit="save" class="p-6 space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Name --}}
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Full Name</label>
                    <div class="relative">
                        <i class="fa-solid fa-user absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="text" wire:model="name" class="w-full pl-10 pr-4 py-3 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]" placeholder="John Doe">
                    </div>
                    @error('name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                {{-- Email --}}
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Email Address</label>
                    <div class="relative">
                        <i class="fa-solid fa-envelope absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="email" wire:model="email" class="w-full pl-10 pr-4 py-3 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]" placeholder="admin@example.com">
                    </div>
                    @error('email') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                {{-- Password --}}
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-2">New Password <span class="text-slate-400 font-normal">(leave blank to keep current)</span></label>
                    <div class="relative">
                        <i class="fa-solid fa-lock absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="password" wire:model="password" class="w-full pl-10 pr-4 py-3 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]" placeholder="Min. 8 characters">
                    </div>
                    @error('password') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                {{-- Confirm Password --}}
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Confirm New Password</label>
                    <div class="relative">
                        <i class="fa-solid fa-lock absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="password" wire:model="password_confirmation" class="w-full pl-10 pr-4 py-3 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]" placeholder="Repeat password">
                    </div>
                </div>

                {{-- Role --}}
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Role</label>
                    <div class="flex gap-4">
                        <label class="flex items-center gap-2 px-4 py-3 border border-slate-300 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors has-checked:border-[#dc8034] has-checked:bg-[#dc8034]/5">
                            <input type="radio" wire:model="role" value="admin" class="text-[#dc8034] focus:ring-[#dc8034]">
                            <span class="font-medium text-slate-700">Admin</span>
                            <span class="text-xs text-slate-500">(Can manage products)</span>
                        </label>
                        <label class="flex items-center gap-2 px-4 py-3 border border-slate-300 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors has-checked:border-[#dc8034] has-checked:bg-[#dc8034]/5">
                            <input type="radio" wire:model="role" value="superadmin" class="text-[#dc8034] focus:ring-[#dc8034]">
                            <span class="font-medium text-slate-700">Superadmin</span>
                            <span class="text-xs text-slate-500">(Full access)</span>
                        </label>
                    </div>
                    @error('role') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            {{-- Submit --}}
            <div class="pt-4 border-t border-slate-100">
                <button type="submit" class="inline-flex items-center px-6 py-3 bg-[#dc8034] text-white font-semibold rounded-lg shadow hover:bg-[#c06d28] transition-colors">
                    <i class="fa-solid fa-save mr-2"></i>
                    Update User
                </button>
            </div>
        </form>
    </div>
</div>
