<div>
    {{-- Article Header --}}
    <section class="pt-24 py-12 bg-slate-50 border-b border-slate-200">
        <div class="container mx-auto px-6 max-w-4xl">
            <div class="flex w-full items-start md:items-center gap-6 ">
                <a href="{{ route('home') }}" class="shrink-0 inline-flex items-center justify-center w-12 h-12 rounded-full bg-white border border-slate-200 text-slate-700 hover:bg-slate-50 hover:text-[#dc8034] hover:border-[#dc8034] transition-all shadow-sm group" title="Back to Home">
                    <i class="fa-solid fa-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                </a>
                
                <div class="grow">
                    <h1 class="text-3xl md:text-5xl font-extrabold text-slate-900 mb-4 leading-tight">
                        {{ $article->title }}
                    </h1>
                    <div class="flex flex-wrap items-center gap-4 md:gap-6 text-sm text-slate-500">
                        <div class="flex items-center gap-2">
                            <i class="fa-regular fa-calendar text-[#dc8034]"></i>
                            {{ $article->published_at->format('M d, Y') }}
                        </div>
                        <div class="flex items-center gap-2">
                            <i class="fa-regular fa-user text-[#dc8034]"></i>
                            {{ $article->author->name ?? 'Admin' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Main Content --}}
    <section class="py-12 bg-white">
        <div class="container mx-auto px-6 max-w-4xl">
            @if($article->image)
                <img src="{{ asset('storage/' . $article->image) }}" alt="{{ $article->title }}" class="w-full h-auto rounded-2xl shadow-lg mb-12">
            @endif

            <div class="prose prose-lg prose-slate max-w-none text-slate-700 leading-relaxed">
                {!! nl2br(e($article->content)) !!}
            </div>

            {{-- Share --}}
            <div class="mt-12 pt-8 border-t border-slate-200 flex items-center justify-between">
                <span class="font-bold text-slate-800">Share this article:</span>
                <div class="flex gap-4">
                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}" target="_blank" class="w-10 h-10 rounded-full bg-blue-600 text-white flex items-center justify-center hover:bg-blue-700 transition-colors">
                        <i class="fa-brands fa-facebook-f"></i>
                    </a>
                    <a href="https://twitter.com/intent/tweet?url={{ url()->current() }}&text={{ urlencode($article->title) }}" target="_blank" class="w-10 h-10 rounded-full bg-sky-500 text-white flex items-center justify-center hover:bg-sky-600 transition-colors">
                        <i class="fa-brands fa-twitter"></i>
                    </a>
                    <a href="https://wa.me/?text={{ urlencode($article->title . ' ' . url()->current()) }}" target="_blank" class="w-10 h-10 rounded-full bg-green-500 text-white flex items-center justify-center hover:bg-green-600 transition-colors">
                        <i class="fa-brands fa-whatsapp"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    {{-- Related Articles --}}
    @if($latestArticles->count() > 0)
    <section class="py-12 bg-slate-50 border-t border-slate-200">
        <div class="container mx-auto px-6">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 max-w-4xl mx-auto">More Articles</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-4xl mx-auto">
                @foreach($latestArticles as $related)
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm hover:shadow-md transition-all duration-300 border border-slate-200 group flex flex-col h-full">
                        <a href="{{ route('articles.show', $related->slug) }}" class="block overflow-hidden h-40 relative">
                            @if($related->image)
                                <img src="{{ asset('storage/' . $related->image) }}" alt="{{ $related->title }}" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-105">
                            @else
                                <div class="w-full h-full bg-slate-100 flex items-center justify-center text-slate-300">
                                    <i class="fa-solid fa-image text-3xl"></i>
                                </div>
                            @endif
                        </a>
                        <div class="p-5 flex flex-col grow">
                             <div class="text-xs text-slate-500 mb-2">
                                {{ $related->published_at->format('M d, Y') }}
                            </div>
                            <h3 class="text-lg font-bold text-slate-800 mb-2 line-clamp-2 hover:text-[#dc8034] transition-colors">
                                <a href="{{ route('articles.show', $related->slug) }}">
                                    {{ $related->title }}
                                </a>
                            </h3>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif
</div>
