<div class="min-h-screen flex flex-col bg-white pt-24">
    <div class="container mx-auto px-6 mb-6">
        <div class="max-w-3xl">
            <span class="block text-[#dc8034] font-bold tracking-widest uppercase mb-3 text-sm">Premium Fleet</span>
            <h1 class="text-4xl md:text-5xl font-extrabold text-[#2b6497] mb-6">Our Car Collection</h1>
            <p class="text-lg text-slate-500 leading-relaxed max-w-2xl">
                Choose from our wide selection of quality vehicles. From compact city cars to spacious family SUVs, we have the perfect ride for your Bali journey.
            </p>
        </div>
    </div>

    {{-- Minimalist Filters --}}
    <div class="container mx-auto px-6 mb-6">
        <div class="inline-flex flex-col sm:flex-row gap-4 bg-white p-2 rounded-xl border border-slate-200 shadow-sm">
            {{-- Brand Filter --}}
            <div class="relative min-w-[200px]">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fa-solid fa-car text-slate-400 text-sm"></i>
                </div>
                <select wire:model.live="brandFilter" class="w-full bg-slate-50 border-0 rounded-lg py-2.5 pl-10 pr-8 text-sm font-semibold text-slate-700 focus:ring-2 focus:ring-[#dc8034] cursor-pointer hover:bg-slate-100 transition-colors">
                    <option value="">All Brands</option>
                    @foreach($brands as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Transmission Filter --}}
            <div class="relative min-w-[200px]">
                 <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fa-solid fa-gears text-slate-400 text-sm"></i>
                </div>
                <select wire:model.live="transmissionFilter" class="w-full bg-slate-50 border-0 rounded-lg py-2.5 pl-10 pr-8 text-sm font-semibold text-slate-700 focus:ring-2 focus:ring-[#dc8034] cursor-pointer hover:bg-slate-100 transition-colors">
                    <option value="">Any Transmission</option>
                    <option value="Automatic">Automatic</option>
                    <option value="Manual">Manual</option>
                </select>
            </div>
            
            @if($brandFilter || $transmissionFilter)
                <button wire:click="clearFilters" class="px-4 py-2.5 text-sm font-semibold text-red-500 hover:text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                    Reset
                </button>
            @endif
        </div>
    </div>

    {{-- Cars Grid --}}
    <div class="container mx-auto px-6 pb-24">
        {{-- Existing Grid Logic --}}
        <div wire:loading.class="opacity-50" class="transition-opacity duration-200">
             {{-- Header with Count --}}
             <div class="flex items-center justify-between mb-8 border-b border-slate-100 pb-4">
                <h2 class="text-xl font-bold text-slate-800">Available Vehicles</h2>
                <div class="text-sm text-slate-500">
                    Found <span class="font-bold text-[#dc8034]">{{ $cars->count() }}</span> cars
                </div>
            </div>
            
             @if($cars->count() > 0)
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-3 md:gap-6">
                    @foreach($cars as $car)
                        <livewire:components.car-card :car="$car" :key="$car->id" />
                    @endforeach
                </div>
            @else
                <div class="text-center py-20 bg-slate-50 rounded-2xl border border-dashed border-slate-200">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white rounded-full mb-6 shadow-sm">
                        <i class="fa-solid fa-car text-4xl text-slate-300"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-800 mb-2">No Cars Found</h3>
                    <p class="text-slate-500 mb-6 max-w-md mx-auto">
                        We couldn't find any cars matching your criteria. Try adjusting your filters.
                    </p>
                    <button wire:click="clearFilters" class="px-6 py-2.5 bg-[#2b6497] text-white rounded-lg hover:bg-[#1e4b75] transition-colors font-medium shadow-lg shadow-[#2b6497]/20">
                        Clear Filters
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>
