<div 
    x-data="{ 
        activeSlide: 0, 
        slides: {{ json_encode($slides) }},
        timer: null,
        next() {
            this.activeSlide = (this.activeSlide + 1) % this.slides.length;
        },
        startAutoplay() {
            this.timer = setInterval(() => this.next(), 5000);
        }
    }" 
    x-init="startAutoplay()"
    class="relative h-[600px] w-full overflow-hidden bg-slate-900"
>
    {{-- Slides --}}
    <template x-for="(slide, index) in slides" :key="index">
        <div 
            x-show="activeSlide === index"
            x-transition:enter="transition ease-in-out duration-1000"
            x-transition:enter-start="opacity-0 scale-105"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="transition ease-in-out duration-1000"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0"
            class="absolute inset-0 bg-cover bg-center"
            :style="`background-image: url('${slide.image}')`"
        >
            <div class="absolute inset-0 bg-black/50"></div>
        </div>
    </template>

    {{-- Content --}}
    <div class="absolute inset-0 z-10 flex items-center">
        <div class="container mx-auto px-6 md:px-12">
            <template x-for="(slide, index) in slides" :key="index">
                <div x-show="activeSlide === index" 
                     x-transition:enter="transition ease-out duration-700 delay-300"
                     x-transition:enter-start="opacity-0 translate-y-10"
                     x-transition:enter-end="opacity-100 translate-y-0"
                     class="max-w-3xl"
                >
                    <span class="inline-block mb-4 px-4 py-1.5 rounded-full bg-[#dc8034] text-white text-sm font-medium shadow-lg shadow-[#dc8034]/20">
                        Trusted Rental in Bali
                    </span>
                    <h1 class="text-4xl md:text-6xl font-bold text-white mb-6 leading-tight" x-text="slide.title"></h1>
                    <p class="text-lg md:text-xl text-slate-200 mb-8 max-w-2xl leading-relaxed">
                        Experience the ultimate freedom of exploring Bali at your own pace. With our premium fleet of well-maintained motorbikes and cars, your perfect island getaway starts the moment you turn the key.
                    </p>
                    
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a 
                            href="https://wa.me/{{ $whatsappNumber }}?text=Hello,%20I%20want%20to%20book%20a%20vehicle" 
                            target="_blank"
                            class="inline-flex items-center justify-center px-8 py-3.5 bg-[#dc8034] hover:bg-[#dc8034]/90 text-white font-bold rounded-lg shadow-xl hover:-translate-y-1 transition-all duration-300"
                        >
                            <i class="fa-brands fa-whatsapp text-xl mr-2"></i>
                            Chat via WhatsApp
                        </a>
                         <button 
                            @click="document.getElementById('cars')?.scrollIntoView({ behavior: 'smooth' })"
                            class="inline-flex items-center justify-center px-8 py-3.5 bg-white/10 hover:bg-white/20 border border-white/30 text-white font-bold rounded-lg backdrop-blur-sm hover:-translate-y-1 transition-all duration-300"
                        >
                            View Our Fleet
                        </button>
                    </div>
                </div>
            </template>
        </div>
    </div>

    {{-- Indicators --}}
    <div class="absolute bottom-10 left-0 right-0 z-20 flex justify-center space-x-3">
        <template x-for="(slide, index) in slides" :key="index">
            <button 
                @click="activeSlide = index; clearInterval(timer); startAutoplay()" 
                class="w-3 h-3 rounded-full transition-all duration-300"
                :class="activeSlide === index ? 'bg-[#dc8034] w-8' : 'bg-white/50 hover:bg-white'"
            ></button>
        </template>
    </div>
</div>
