@props(['motor'])

<div class="group bg-white rounded-2xl overflow-hidden border border-neutral-100 shadow-sm hover:shadow-xl transition-all duration-300 hover:-translate-y-1 flex flex-col h-full">
    {{-- Image Area --}}
    <div class="relative h-36 md:h-48 overflow-hidden bg-neutral-100 shrink-0">
        @if($motor->main_image)
            @php
                $imageSrc = $motor->main_image;
                if (!str_starts_with($imageSrc, 'http')) {
                    $imageSrc = asset('storage/' . $imageSrc);
                }
            @endphp
            <img 
                src="{{ $imageSrc }}" 
                alt="{{ $motor->name }}" 
                class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700"
                onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1449426468159-d96dbf08f19f?w=800&h=600&fit=crop'; this.classList.add('opacity-70');"
            />
        @else
            <div class="w-full h-full flex items-center justify-center bg-linear-to-br from-slate-100 to-slate-200">
                <div class="text-center">
                    <i class="fa-solid fa-motorcycle text-3xl md:text-4xl text-slate-300 mb-2"></i>
                    <p class="text-[10px] md:text-xs text-slate-400">No Image</p>
                </div>
            </div>
        @endif
        {{-- Overlay on Hover --}}
        <div class="absolute inset-0 bg-black/20 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </div>

    {{-- Content --}}
    <div class="p-3 md:p-5 flex flex-col grow">
        <div class="flex items-center gap-2 mb-1 md:mb-2">
             @if($motor->brand && $motor->brand->logo)
                <img src="{{ $motor->brand->logo }}" alt="{{ $motor->brand->name }}" class="w-4 h-4 md:w-5 md:h-5 object-contain opacity-70" />
            @else
                <span class="text-[10px] md:text-xs font-semibold text-neutral-400 uppercase tracking-wider">{{ $motor->brand->name ?? 'Unknown' }}</span>
            @endif
        </div>
        
        <h3 class="text-sm md:text-lg font-bold text-neutral-800 mb-1 group-hover:text-[#dc8034] transition-colors line-clamp-1">
            {{ $motor->name }}
        </h3>
        
        <div class="flex items-center gap-1 md:gap-2 mb-2 md:mb-4 text-[10px] md:text-xs text-neutral-500">
            <div class="flex items-center gap-1 bg-neutral-50 px-1.5 py-0.5 md:px-2 md:py-1 rounded">
                <span class="font-bold">{{ $motor->cc }}</span>
                <span>CC</span>
            </div>
            <div class="flex items-center gap-1 bg-neutral-50 px-1.5 py-0.5 md:px-2 md:py-1 rounded">
                <i class="fa-solid fa-gear text-[8px] md:text-[10px]"></i>
                <span>{{ $motor->transmission }}</span>
            </div>
        </div>
        
        <div class="mt-auto pt-2 md:pt-4 border-t border-neutral-100 flex items-center justify-between">
            <div>
                <p class="hidden md:block text-xs text-neutral-400 uppercase tracking-wide font-medium">Daily Rate</p>
                <div class="flex items-baseline gap-1">
                    <span class="text-sm md:text-lg font-extrabold text-[#2b6497]">
                         Rp {{ number_format($motor->price_daily, 0, ',', '.') }}
                    </span>
                    <span class="text-[10px] md:text-xs text-neutral-400 font-medium">/day</span>
                </div>
            </div>
        </div>
        
        <div class="mt-3 md:mt-4 grid grid-cols-1 md:grid-cols-2 gap-2">
            <a 
                href="{{ route('motors.show', $motor->id) }}"
                class="inline-flex items-center justify-center px-3 py-1.5 md:px-4 md:py-2 bg-white border border-neutral-200 text-neutral-700 text-xs md:text-sm font-semibold rounded-lg hover:bg-neutral-50 hover:text-[#dc8034] hover:border-[#dc8034] transition-all w-full"
            >
                Detail
            </a>
            <a 
                href="https://wa.me/{{ $whatsappNumber }}?text=Hello,%20I%20want%20to%20book%20{{ urlencode($motor->name) }}"
                target="_blank"
                class="inline-flex items-center justify-center px-3 py-1.5 md:px-4 md:py-2 bg-[#dc8034] text-white text-xs md:text-sm font-semibold rounded-lg hover:bg-[#dc8034]/90 shadow-md hover:shadow-lg hover:-translate-y-0.5 transition-all w-full"
            >
                <i class="fa-brands fa-whatsapp mr-1.5"></i>
                Book
            </a>
        </div>
    </div>
</div>
