<div class="relative -mt-18 z-20 container mx-auto px-6 mb-12">
    <div class="bg-white rounded-xl shadow-lg p-4 flex flex-col gap-4 border border-slate-100 max-w-4xl mx-auto">
        <div class="flex flex-col md:flex-row items-center gap-4 w-full">

            <div class="w-full grid grid-cols-1 md:grid-cols-4 gap-4 items-end grow">
                {{-- Vehicle Type --}}
                <div class="space-y-1 w-full">
                    <label class="text-[10px] font-bold text-slate-400 uppercase tracking-wider block">
                        Vehicle Type
                    </label>
                    <div class="relative">
                        <select wire:model.live="vehicleType" class="w-full bg-slate-50 border-slate-200 h-10 text-sm rounded cursor-pointer focus:ring-[#dc8034]/20 focus:border-[#dc8034]">
                            <option value="car">Car</option>
                            <option value="motor">Motorbike</option>
                        </select>
                    </div>
                </div>

                {{-- Transmission --}}
                <div class="space-y-1 w-full">
                    <label class="text-[10px] font-bold text-slate-400 uppercase tracking-wider block">
                        Transmission
                    </label>
                    <div class="relative">
                         <select wire:model="selectedTransmission" class="w-full bg-slate-50 border-slate-200 h-10 text-sm rounded cursor-pointer focus:ring-[#dc8034]/20 focus:border-[#dc8034]">
                            <option value="">Any Transmission</option>
                            <option value="Automatic">Automatic</option>
                            <option value="Manual">Manual</option>
                        </select>
                    </div>
                </div>

                {{-- Brand --}}
                <div class="space-y-1 w-full">
                    <label class="text-[10px] font-bold text-slate-400 uppercase tracking-wider block">
                        Brand
                    </label>
                    <div class="relative">
                         <select wire:model="selectedBrand" class="w-full bg-slate-50 border-slate-200 h-10 text-sm rounded cursor-pointer focus:ring-[#dc8034]/20 focus:border-[#dc8034]">
                            <option value="">Any Brand</option>
                            @foreach($brands as $brand)
                                <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                {{-- Search Button --}}
                <button
                    wire:click="search"
                    class="w-full h-10 bg-[#dc8034] hover:bg-[#dc8034]/90 text-white font-bold text-sm rounded shadow-md shadow-[#dc8034]/20 transition-all hover:scale-[1.02] active:scale-[0.98] cursor-pointer flex items-center justify-center shrink-0"
                >
                    <i class="fa-solid fa-magnifying-glass mr-2"></i> Search
                </button>
            </div>
        </div>
    </div>
</div>
