    <main class="flex-1 py-10 pt-24">
        <div class="container mx-auto px-4 md:px-6">
             {{-- Back Button --}}
             <div class="mb-6">
                <a href="{{ route('motors.index') }}" class="inline-flex items-center justify-center px-4 py-2 bg-white border border-neutral-200 text-neutral-700 text-sm font-semibold rounded-full hover:bg-neutral-50 hover:text-[#dc8034] hover:border-[#dc8034] transition-all">
                    <i class="fa-solid fa-arrow-left mr-2"></i>
                    Back to Motorbikes
                </a>
             </div>

            <div class="grid grid-cols-1 lg:grid-cols-12 gap-10">
                {{-- Left Column - Details (8 cols) --}}
                <div class="lg:col-span-8 space-y-10">
                    {{-- Product Header (Mobile only) --}}
                    <div class="lg:hidden">
                        <div class="flex items-center gap-2 mb-2">
                             <span class="bg-neutral-100 text-neutral-600 px-2 py-0.5 rounded text-xs font-bold uppercase tracking-wider border border-neutral-200">
                                {{ $motor->brand->name ?? 'Unknown' }}
                            </span>
                             <span class="text-neutral-500 text-sm">{{ $motor->cc }} CC</span>
                        </div>
                        <h1 class="text-3xl font-black text-neutral-900 mb-2">{{ $motor->name }}</h1>
                    </div>

                    {{-- Image Gallery --}}
                    @php
                        // Prepend /storage/ to all paths
                        $galleryImages = [];
                        if ($motor->main_image) {
                            $img = $motor->main_image;
                            $galleryImages[] = str_starts_with($img, 'http') ? $img : asset('storage/' . $img);
                        }
                        if (!empty($motor->images) && is_array($motor->images)) {
                            foreach ($motor->images as $img) {
                                if (!empty($img) && $img !== $motor->main_image) {
                                    $galleryImages[] = str_starts_with($img, 'http') ? $img : asset('storage/' . $img);
                                }
                            }
                        }
                    @endphp

                    @if(count($galleryImages) > 0)
                        <div class="space-y-4" x-data="{ selectedImage: 0, images: {{ json_encode($galleryImages) }} }">
                            <div class="relative aspect-video bg-neutral-100 rounded-2xl overflow-hidden border border-neutral-200 shadow-sm">
                                <img 
                                    :src="images[selectedImage]" 
                                    alt="{{ $motor->name }}" 
                                    class="w-full h-full object-cover transition-opacity duration-300"
                                    onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1449426468159-d96dbf08f19f?w=800&h=600&fit=crop';"
                                />
                                
                                {{-- Navigation Arrows --}}
                                <template x-if="images.length > 1">
                                    <div>
                                        <button 
                                            @click="selectedImage = (selectedImage - 1 + images.length) % images.length"
                                            class="absolute left-3 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-white/90 backdrop-blur-sm shadow-lg flex items-center justify-center text-neutral-700 hover:bg-white hover:text-[#dc8034] transition-all"
                                        >
                                            <i class="fa-solid fa-chevron-left"></i>
                                        </button>
                                        <button 
                                            @click="selectedImage = (selectedImage + 1) % images.length"
                                            class="absolute right-3 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-white/90 backdrop-blur-sm shadow-lg flex items-center justify-center text-neutral-700 hover:bg-white hover:text-[#dc8034] transition-all"
                                        >
                                            <i class="fa-solid fa-chevron-right"></i>
                                        </button>
                                    </div>
                                </template>
                                
                                {{-- Status Badge --}}
                                 <div class="absolute top-4 right-4">
                                    @if($motor->status === 'available')
                                        <span class="bg-white/90 text-emerald-600 backdrop-blur-md border border-emerald-100 shadow-sm px-3 py-1.5 rounded-full text-xs font-bold uppercase tracking-wider">
                                            Available
                                        </span>
                                    @else
                                        <span class="bg-white/90 text-amber-600 backdrop-blur-md border border-amber-100 shadow-sm px-3 py-1.5 rounded-full text-xs font-bold uppercase tracking-wider">
                                            {{ ucfirst($motor->status) }}
                                        </span>
                                    @endif
                                </div>
                                
                                {{-- Image Counter --}}
                                <template x-if="images.length > 1">
                                    <div class="absolute bottom-4 left-4 bg-black/60 backdrop-blur-sm text-white text-xs font-medium px-3 py-1.5 rounded-full">
                                        <span x-text="(selectedImage + 1) + ' / ' + images.length"></span>
                                    </div>
                                </template>
                            </div>
                            
                            {{-- Thumbnail Strip --}}
                            <template x-if="images.length > 1">
                                <div class="flex gap-3 overflow-x-auto pb-2 px-1 pt-1">
                                    <template x-for="(img, index) in images" :key="index">
                                        <button 
                                            @click="selectedImage = index"
                                            :class="selectedImage === index ? 'ring-2 ring-[#dc8034] ring-offset-2' : 'ring-1 ring-neutral-200 hover:ring-neutral-300'"
                                            class="shrink-0 w-20 h-14 rounded-lg overflow-hidden bg-neutral-100 transition-all"
                                        >
                                            <img :src="img" alt="" class="w-full h-full object-cover" onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1449426468159-d96dbf08f19f?w=200&h=150&fit=crop';">
                                        </button>
                                    </template>
                                </div>
                            </template>
                        </div>
                    @else
                        {{-- Placeholder --}}
                        <div class="relative aspect-video bg-slate-100 rounded-2xl overflow-hidden border border-neutral-200 shadow-sm flex items-center justify-center">
                            <div class="text-center">
                                <i class="fa-solid fa-motorcycle text-6xl text-slate-300 mb-4"></i>
                                <p class="text-slate-400 font-medium">No bike images available</p>
                            </div>

                            {{-- Status Badge --}}
                            <div class="absolute top-4 right-4">
                                @if($motor->status === 'available')
                                    <span class="bg-white/90 text-emerald-600 backdrop-blur-md border border-emerald-100 shadow-sm px-3 py-1.5 rounded-full text-xs font-bold uppercase tracking-wider">
                                        Available
                                    </span>
                                @else
                                    <span class="bg-white/90 text-amber-600 backdrop-blur-md border border-amber-100 shadow-sm px-3 py-1.5 rounded-full text-xs font-bold uppercase tracking-wider">
                                        {{ ucfirst($motor->status) }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    @endif

                    {{-- Product Header (Desktop) --}}
                    <div class="hidden lg:block border-b border-neutral-200 pb-8">
                        <div class="flex items-center gap-3 mb-3">
                            <span class="bg-neutral-100 text-neutral-600 px-2.5 py-1 rounded text-xs font-bold uppercase tracking-wider border border-neutral-200">
                                {{ $motor->brand->name ?? 'Unknown' }}
                            </span>
                            <span class="text-neutral-400 text-sm">•</span>
                            <span class="text-neutral-500 text-sm font-medium">{{ $motor->cc }} CC</span>
                        </div>
                        <h1 class="text-4xl font-black text-[#2b6497] mb-4 tracking-tight">{{ $motor->name }}</h1>
                         <p class="text-lg text-neutral-600 leading-relaxed max-w-3xl">
                            {{ $motor->description ?: "Rent our premium {$motor->name} for your Bali adventure. Well maintained and reliable." }}
                        </p>
                    </div>

                    {{-- Specifications --}}
                    <section class="space-y-6">
                         <h3 class="text-xl font-bold text-[#2b6497] flex items-center gap-2">
                            <i class="fa-solid fa-gear"></i> Specifications
                        </h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                             <div class="p-4 rounded-xl border border-neutral-200 bg-white hover:border-neutral-300 transition-colors">
                                <span class="text-xs text-neutral-400 font-medium uppercase tracking-wider block mb-2">Transmission</span>
                                <div class="flex items-center gap-2 text-neutral-900 font-semibold">
                                    <i class="fa-solid fa-gear text-[#dc8034]"></i>
                                    {{ $motor->transmission }}
                                </div>
                            </div>
                             <div class="p-4 rounded-xl border border-neutral-200 bg-white hover:border-neutral-300 transition-colors">
                                <span class="text-xs text-neutral-400 font-medium uppercase tracking-wider block mb-2">Engine</span>
                                <div class="flex items-center gap-2 text-neutral-900 font-semibold">
                                    <i class="fa-solid fa-bolt text-[#dc8034]"></i>
                                    {{ $motor->cc }} CC
                                </div>
                            </div>
                        </div>
                    </section>

                    {{-- Requirements Info --}}
                     <section class="bg-[#1a3c5a] rounded-2xl p-8 text-white relative overflow-hidden">
                         <div class="absolute top-0 right-0 p-32 bg-[#dc8034]/10 rounded-full blur-3xl -translate-y-1/2 translate-x-1/2"></div>
                         
                         <h3 class="text-xl font-bold mb-6 flex items-center gap-2 relative z-10">
                            <i class="fa-solid fa-shield-halved text-orange-400"></i> Rental Requirements
                        </h3>

                        <div class="grid md:grid-cols-2 gap-x-8 gap-y-4 relative z-10">
                             <div class="flex items-start gap-3 text-sm text-neutral-300">
                                <i class="fa-solid fa-circle-check text-orange-500 mt-0.5"></i>
                                <span>Valid ID / Passport required</span>
                            </div>
                             <div class="flex items-start gap-3 text-sm text-neutral-300">
                                 <i class="fa-solid fa-circle-check text-orange-500 mt-0.5"></i>
                                <span>Valid Driving License (SIM C)</span>
                            </div>
                              <div class="flex items-start gap-3 text-sm text-neutral-300">
                                 <i class="fa-solid fa-circle-check text-orange-500 mt-0.5"></i>
                                <span>Minimum rental duration: 24 Hours</span>
                            </div>
                             <div class="flex items-start gap-3 text-sm text-neutral-300">
                                 <i class="fa-solid fa-circle-check text-orange-500 mt-0.5"></i>
                                <span>Deposit required (Refundable)</span>
                            </div>
                        </div>
                     </section>
                </div>

                {{-- Right Column - Booking Form (4 cols) --}}
                {{-- Right Column - Booking Form (4 cols) --}}
                <div class="lg:col-span-4" 
                     x-data="{ 
                        handleWhatsapp(url) {
                            window.open(url, '_blank');
                        }
                     }"
                     @open-whatsapp.window="handleWhatsapp($event.detail.url)"
                >
                    <div class="sticky top-24 space-y-6">
                        <div class="bg-white rounded-2xl border border-neutral-200 shadow-xl shadow-neutral-200/50 overflow-hidden">
                            <div class="p-6 border-b border-neutral-100 bg-[#2b6497]/5">
                                <p class="text-sm text-neutral-500 font-medium mb-1">Starting from</p>
                                <div class="flex items-baseline gap-2">
                                    <span class="text-3xl font-black text-neutral-900 tracking-tight">
                                        Rp {{ number_format($motor->price_daily, 0, ',', '.') }}
                                    </span>
                                    <span class="text-neutral-500 font-medium">/day</span>
                                </div>
                            </div>

                            <div class="p-6 space-y-4">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-1">Full Name</label>
                                    <input type="text" wire:model="bookingName" class="w-full rounded-lg border-gray-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]" placeholder="Your Name">
                                    @error('bookingName') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-1">Date</label>
                                    <input type="date" wire:model="bookingDate" class="w-full rounded-lg border-gray-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]">
                                    @error('bookingDate') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-1">Duration (Days)</label>
                                    <input type="number" wire:model="bookingDuration" min="1" class="w-full rounded-lg border-gray-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]">
                                    @error('bookingDuration') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <button 
                                    wire:click="submitBooking"
                                    class="flex items-center justify-center w-full h-12 text-base font-bold bg-[#dc8034] hover:bg-[#c26d26] text-white shadow-lg rounded-lg transition-all duration-300 hover:-translate-y-1 mt-2"
                                >
                                    <i class="fa-brands fa-whatsapp text-lg mr-2"></i>
                                    Request Booking
                                </button>
                                
                                <p class="text-xs text-center text-neutral-400">
                                    Includes Helmet & Raincoat.<br>
                                    We will redirect you to WhatsApp to confirm availability.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
