<div class="bg-white min-h-screen pt-24 pb-12">
    <div class="container mx-auto px-6">
        <div class="mb-6">
            <a href="{{ route('tours.index') }}" class="inline-flex items-center justify-center px-4 py-2 bg-white border border-neutral-200 text-neutral-700 text-sm font-semibold rounded-full hover:bg-neutral-50 hover:text-[#dc8034] hover:border-[#dc8034] transition-all">
                <i class="fa-solid fa-arrow-left mr-2"></i>
                Back to Tours
            </a>
         </div>
        <div class="flex flex-col lg:flex-row gap-12">
            {{-- Left Column: Images & Content --}}
            <div class="lg:w-2/3">
                {{-- Main Image Gallery --}}
                @php
                    // Handle both URL and storage paths for tour images
                    $galleryImages = [];
                    if ($tour->main_image) {
                        $img = $tour->main_image;
                        $galleryImages[] = str_starts_with($img, 'http') ? $img : asset('storage/' . $img);
                    }
                    
                    if (!empty($tour->images) && is_array($tour->images)) {
                        foreach ($tour->images as $img) {
                            if (!empty($img) && $img !== $tour->main_image) {
                                $galleryImages[] = str_starts_with($img, 'http') ? $img : asset('storage/' . $img);
                            }
                        }
                    }
                @endphp

                <div class="mb-8">
                    @if(count($galleryImages) > 0)
                        <div x-data="{ selectedImage: 0, images: {{ json_encode($galleryImages) }} }">
                            <div class="rounded-2xl overflow-hidden shadow-sm h-[400px] relative group border border-neutral-200">
                                <img 
                                    :src="images[selectedImage]" 
                                    alt="{{ $tour->name }}" 
                                    class="w-full h-full object-cover transition-opacity duration-300"
                                    onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800&h=600&fit=crop';"
                                >
                                
                                {{-- Navigation Arrows --}}
                                <template x-if="images.length > 1">
                                    <div>
                                        <button 
                                            @click="selectedImage = (selectedImage - 1 + images.length) % images.length"
                                            class="absolute left-3 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-white/90 backdrop-blur-sm shadow-lg flex items-center justify-center text-neutral-700 hover:bg-white hover:text-[#dc8034] transition-all"
                                        >
                                            <i class="fa-solid fa-chevron-left"></i>
                                        </button>
                                        <button 
                                            @click="selectedImage = (selectedImage + 1) % images.length"
                                            class="absolute right-3 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-white/90 backdrop-blur-sm shadow-lg flex items-center justify-center text-neutral-700 hover:bg-white hover:text-[#dc8034] transition-all"
                                        >
                                            <i class="fa-solid fa-chevron-right"></i>
                                        </button>
                                    </div>
                                </template>
                                
                                {{-- Badges --}}
                                <div class="absolute top-6 left-6 flex gap-2">
                                    <span class="px-4 py-1.5 bg-white/90 backdrop-blur text-[#2b6497] text-sm font-bold rounded-full shadow-sm">
                                        {{ $tour->category }}
                                    </span>
                                    <span class="px-4 py-1.5 bg-black/60 backdrop-blur text-white text-sm font-bold rounded-full shadow-sm">
                                        {{ $tour->duration }}
                                    </span>
                                </div>
                                
                                {{-- Image Counter --}}
                                <template x-if="images.length > 1">
                                    <div class="absolute bottom-4 right-4 bg-black/60 backdrop-blur-sm text-white text-xs font-medium px-3 py-1.5 rounded-full">
                                        <span x-text="(selectedImage + 1) + ' / ' + images.length"></span>
                                    </div>
                                </template>
                            </div>
                            
                            {{-- Thumbnail Strip --}}
                            <template x-if="images.length > 1">
                                <div class="flex gap-3 overflow-x-auto pb-2 mt-4 px-1 pt-1">
                                    <template x-for="(img, index) in images" :key="index">
                                        <button 
                                            @click="selectedImage = index"
                                            :class="selectedImage === index ? 'ring-2 ring-[#dc8034] ring-offset-2' : 'ring-1 ring-neutral-200 hover:ring-neutral-300'"
                                            class="shrink-0 w-20 h-14 rounded-lg overflow-hidden bg-neutral-100 transition-all"
                                        >
                                            <img :src="img" alt="" class="w-full h-full object-cover" onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=200&h=150&fit=crop';">
                                        </button>
                                    </template>
                                </div>
                            </template>
                        </div>
                    @else
                        {{-- Placeholder --}}
                        <div class="rounded-2xl overflow-hidden shadow-sm h-[400px] relative group border border-neutral-200 bg-slate-100 flex items-center justify-center">
                            <div class="text-center">
                                <i class="fa-solid fa-map-location-dot text-6xl text-slate-300 mb-4"></i>
                                <p class="text-slate-400 font-medium">No tour images</p>
                            </div>

                            {{-- Badges (Still show badges) --}}
                            <div class="absolute top-6 left-6 flex gap-2">
                                <span class="px-4 py-1.5 bg-white/90 backdrop-blur text-[#2b6497] text-sm font-bold rounded-full shadow-sm">
                                    {{ $tour->category }}
                                </span>
                                <span class="px-4 py-1.5 bg-black/60 backdrop-blur text-white text-sm font-bold rounded-full shadow-sm">
                                    {{ $tour->duration }}
                                </span>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="mb-8">
                    <h1 class="text-3xl md:text-4xl font-extrabold text-slate-900 mb-4">{{ $tour->name }}</h1>
                    
                    <div class="flex flex-wrap items-center gap-6 text-sm text-slate-600 mb-6">
                         <div class="flex items-center gap-2">
                            <i class="fa-solid fa-gauge-high text-[#dc8034]"></i>
                            <span>Difficulty: <span class="font-semibold text-slate-900">{{ $tour->difficulty }}</span></span>
                        </div>
                         <div class="flex items-center gap-2">
                            <i class="fa-solid fa-user-group text-[#dc8034]"></i>
                            <span>Max People: <span class="font-semibold text-slate-900">{{ $tour->max_people }}</span></span>
                        </div>
                        <div class="flex items-center gap-2">
                            <i class="fa-solid fa-star text-amber-400"></i>
                            <span class="font-semibold text-slate-900">5.0</span> <span class="text-slate-400">(24 Reviews)</span>
                        </div>
                    </div>

                    <h2 class="text-xl font-bold text-slate-900 mb-3">About This Tour</h2>
                    <div class="prose prose-slate max-w-none text-slate-600">
                        <p>{{ $tour->description }}</p>
                    </div>
                </div>

                {{-- Highlights (Placeholder for JSON features in future) --}}
                <div class="bg-slate-50 rounded-2xl p-8 mb-8 border border-slate-100">
                    <h3 class="text-lg font-bold text-slate-900 mb-4">Why Choose This Tour?</h3>
                    <ul class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <li class="flex items-start gap-3">
                            <i class="fa-solid fa-circle-check text-emerald-500 mt-1"></i>
                            <span class="text-slate-600">Professional local guide included</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fa-solid fa-circle-check text-emerald-500 mt-1"></i>
                            <span class="text-slate-600">Comfortable AC transportation</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fa-solid fa-circle-check text-emerald-500 mt-1"></i>
                            <span class="text-slate-600">All entrance fees covered</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <i class="fa-solid fa-circle-check text-emerald-500 mt-1"></i>
                            <span class="text-slate-600">Flexible itinerary options</span>
                        </li>
                    </ul>
                </div>
            </div>

            {{-- Right Column: Booking Card --}}
            <div class="lg:w-1/3"
                 x-data="{ 
                    handleWhatsapp(url) {
                        window.open(url, '_blank');
                    }
                 }"
                 @open-whatsapp.window="handleWhatsapp($event.detail.url)"
            >
                <div class="sticky top-24">
                    <div class="bg-white rounded-2xl shadow-xl shadow-slate-200/50 border border-slate-100 overflow-hidden p-6">
                        <div class="flex items-end justify-between mb-6 pb-6 border-b border-slate-100">
                             <div>
                                <span class="text-sm text-slate-400 uppercase font-semibold">Standard Package</span>
                                <div class="text-[#2b6497] font-extrabold text-3xl mt-1">
                                    Rp {{ number_format($tour->price, 0, ',', '.') }}
                                </div>
                                <span class="text-xs text-slate-400">per person (min. 2 pax)</span>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Full Name</label>
                                <input type="text" wire:model="bookingName" class="w-full rounded-lg border-slate-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]" placeholder="Your Name">
                                @error('bookingName') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Date</label>
                                <input type="date" wire:model="bookingDate" class="w-full rounded-lg border-slate-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]">
                                @error('bookingDate') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Number of People</label>
                                <input type="number" wire:model="bookingPax" min="1" class="w-full rounded-lg border-slate-300 py-3 px-4 focus:border-[#dc8034] focus:ring-[#dc8034]">
                                @error('bookingPax') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>

                            <button 
                                wire:click="submitBooking"
                                class="flex items-center justify-center w-full h-12 text-base font-bold bg-[#dc8034] hover:bg-[#c26d26] text-white shadow-lg rounded-lg transition-all duration-300 hover:-translate-y-1 mt-2"
                            >
                                <i class="fa-brands fa-whatsapp text-lg mr-2"></i>
                                Book Tour
                            </button>
                            
                            <p class="text-xs text-center text-slate-400">
                                Customizable itinerary on request.
                            </p>
                        </div>
                        
                        <div class="mt-6 text-center">
                            <p class="text-xs text-slate-400">
                                <i class="fa-solid fa-shield-halved mr-1"></i> Best Price Guarantee • No Hidden Fees
                            </p>
                        </div>
                    </div>

                    {{-- Contact Info --}}
                    <div class="mt-6 bg-slate-50 rounded-xl p-5 border border-slate-100">
                        <h4 class="font-bold text-slate-800 mb-2">Need Help?</h4>
                        <p class="text-sm text-slate-500 mb-4">Talk to our travel expert for personalized itinerary.</p>
                        <a href="tel:+6281234567890" class="flex items-center text-[#2b6497] font-semibold text-sm hover:underline">
                            <i class="fa-solid fa-phone mr-2"></i> +62 812 3456 7890
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
