<div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden group hover:shadow-lg transition-all duration-300 hover:-translate-y-1 h-full flex flex-col">
    <div class="relative aspect-4/3 overflow-hidden shrink-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tour->main_image): ?>
            <?php
                $imageSrc = $tour->main_image;
                if (!str_starts_with($imageSrc, 'http')) {
                    $imageSrc = asset('storage/' . $imageSrc);
                }
            ?>
            <img 
                src="<?php echo e($imageSrc); ?>" 
                alt="<?php echo e($tour->name); ?>" 
                class="absolute inset-0 w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
                onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800&h=600&fit=crop'; this.classList.add('opacity-70');"
            >
        <?php else: ?>
            <div class="absolute inset-0 bg-slate-100 flex items-center justify-center">
                <div class="text-center">
                    <i class="fa-solid fa-map-location-dot text-3xl md:text-4xl text-slate-300 mb-2"></i>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <div class="absolute top-3 left-3 md:top-5 md:left-5">
            <span class="px-2 py-0.5 md:px-3 md:py-1 bg-white/90 backdrop-blur text-[#2b6497] text-[10px] md:text-xs font-bold rounded-full shadow-sm">
                <?php echo e($tour->category); ?>

            </span>
        </div>
        <div class="absolute bottom-3 left-3 md:bottom-5 md:left-5">
            <span class="px-2 py-0.5 md:px-3 md:py-1 bg-black/60 backdrop-blur text-white text-[10px] md:text-xs font-bold rounded-full flex items-center gap-1">
                <i class="fa-regular fa-clock"></i>
                <?php echo e($tour->duration); ?>

            </span>
        </div>
    </div>
    
    <div class="p-3 md:p-6 flex flex-col grow">
        <div class="flex items-center justify-between mb-1 md:mb-2">
             <div class="flex items-center gap-1 text-yellow-500 text-xs md:text-sm">
                <i class="fa-solid fa-star"></i>
                <span class="text-slate-600 font-medium">5.0</span>
            </div>
            <span class="text-[10px] md:text-xs font-semibold text-slate-500 bg-slate-100 px-1.5 py-0.5 md:px-2 md:py-1 rounded">
                <?php echo e($tour->difficulty); ?>

            </span>
        </div>

        <h3 class="text-sm md:text-xl font-bold text-slate-800 mb-1 md:mb-2 line-clamp-1 group-hover:text-[#dc8034] transition-colors">
            <a href="<?php echo e(route('tours.show', $tour)); ?>">
                <?php echo e($tour->name); ?>

            </a>
        </h3>
        
        <p class="hidden md:block text-slate-500 text-sm mb-4 line-clamp-2">
            <?php echo e($tour->description); ?>

        </p>

        <div class="mt-auto flex items-center justify-between pt-2 md:pt-4 border-t border-slate-100">
            <div>
                <span class="hidden md:block text-xs text-slate-400 uppercase tracking-wide">Starting from</span>
                <div class="text-[#2b6497] font-bold text-sm md:text-lg">
                    Rp <?php echo e(number_format($tour->price, 0, ',', '.')); ?>

                </div>
            </div>
            
            <a href="<?php echo e(route('tours.show', $tour)); ?>" class="inline-flex items-center justify-center w-8 h-8 md:w-10 md:h-10 rounded-full bg-slate-50 text-[#dc8034] hover:bg-[#dc8034] hover:text-white transition-all">
                <i class="fa-solid fa-arrow-right text-xs md:text-base"></i>
            </a>
        </div>
    </div>
</div>
<?php /**PATH D:\Kumtura\memet-rental\memet-rental\resources\views/livewire/components/tour-card.blade.php ENDPATH**/ ?>