<?php
    $settings = \App\Models\Setting::pluck('value', 'key');
    $isHomePage = request()->routeIs('home');
    $homeUrl = route('home');
    
    $navItems = [
        ['name' => 'Home', 'href' => $homeUrl],
        ['name' => 'Cars', 'href' => $isHomePage ? '#cars' : $homeUrl . '#cars', 'enabled' => $settings['enable_cars'] ?? 1],
        ['name' => 'Motorbikes', 'href' => $isHomePage ? '#motors' : $homeUrl . '#motors', 'enabled' => $settings['enable_motors'] ?? 1],
        ['name' => 'Tours', 'href' => $isHomePage ? '#tours' : $homeUrl . '#tours', 'enabled' => $settings['enable_tours'] ?? 1],
        ['name' => 'Articles', 'href' => $isHomePage ? '#articles' : $homeUrl . '#articles'],
        ['name' => 'About Us', 'href' => $isHomePage ? '#about' : $homeUrl . '#about'],
        ['name' => 'Contact', 'href' => $isHomePage ? '#contact' : $homeUrl . '#contact'],
    ];
    // Filter disabled items
    $navItems = array_filter($navItems, fn($item) => !isset($item['enabled']) || $item['enabled']);
    $bookingMessage = urlencode($settings['booking_message_template'] ?? "Hello, I want to book a vehicle for rental");
?>



<div 
    x-data="{ 
        scrolled: false, 
        mobileOpen: false, 
        checkScroll() { this.scrolled = window.scrollY > 20 } 
    }"
    x-init="checkScroll()"
    @scroll.window="checkScroll()"
    class="relative z-50"
>
    <header
        :class="{ 'bg-white/95 backdrop-blur-sm shadow-lg border-slate-100 py-3': scrolled, 'bg-white shadow-md border-transparent py-4': !scrolled }"
        class="fixed top-0 z-50 w-full transition-all duration-300 border-b"
    >
        <div class="container mx-auto px-2">
            <div class="flex items-center justify-between">
                
                <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3 group">
                    <div class="relative flex items-center justify-center w-10 h-10 shrink-0">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($settings['brand_logo'])): ?>
                            <img src="<?php echo e($settings['brand_logo']); ?>" alt="Logo" class="w-full h-full object-contain">
                        <?php else: ?>
                            <div class="w-full h-full bg-slate-900 text-white font-black text-lg flex items-center justify-center rounded-md shadow-sm">
                                MR
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="flex flex-row items-baseline space-x-2">
                        <span class="font-black text-2xl tracking-tight text-[#2b6497] leading-none">MEMET</span>
                        <span class="font-bold text-2xl tracking-tight text-[#dc8034] leading-none">RENTAL</span>
                    </div>
                </a>

                
                <nav class="hidden lg:flex items-center space-x-7 ml-10">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $navItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($item['href']); ?>" class="relative text-sm font-semibold tracking-wide py-1 transition-colors duration-200 group text-slate-500 hover:text-[#2b6497] <?php echo e(request()->url() == $item['href'] ? 'text-[#2b6497]' : ''); ?>">
                            <?php echo e($item['name']); ?>

                            <span class="absolute bottom-0 left-0 h-0.5 bg-[#dc8034] transition-all duration-300 ease-out <?php echo e(request()->url() == $item['href'] ? 'w-full' : 'w-0 group-hover:w-full'); ?>"></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </nav>

                
                <div class="flex items-center space-x-5 ml-8">
                    
                    <a 
                        href="https://wa.me/<?php echo e($settings['whatsapp_number'] ?? '6281234567890'); ?>?text=<?php echo e($bookingMessage); ?>" 
                        target="_blank"
                        class="hidden md:flex items-center space-x-2 px-6 py-2.5 rounded-full text-sm font-bold transition-all duration-300 shadow-sm border border-transparent bg-[#dc8034] text-white hover:bg-[#dc8034]/90 hover:shadow-lg hover:-translate-y-0.5"
                    >
                        <i class="fa-solid fa-phone"></i>
                        <span>Book Now</span>
                    </a>

                    
                    <button @click="mobileOpen = true" class="lg:hidden text-slate-700 hover:bg-slate-100 rounded-full w-10 h-10 flex items-center justify-center transition-colors">
                        <i class="fa-solid fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
    </header>

    
    <div 
        x-show="mobileOpen" 
        style="display: none;"
        class="fixed inset-0 z-60 flex justify-end"
    >
        
        <div @click="mobileOpen = false" x-show="mobileOpen" x-transition.opacity class="fixed inset-0 bg-black/50"></div>

        
        <div 
            x-show="mobileOpen" 
            x-transition:enter="transform transition ease-in-out duration-300"
            x-transition:enter-start="translate-x-full"
            x-transition:enter-end="translate-x-0"
            x-transition:leave="transform transition ease-in-out duration-300"
            x-transition:leave-start="translate-x-0"
            x-transition:leave-end="translate-x-full"
            class="relative w-[300px] sm:w-[350px] bg-white h-full shadow-xl flex flex-col"
        >
            <div class="p-6 border-b border-slate-100 flex items-center justify-between">
                 <div class="flex flex-row items-baseline space-x-2">
                    <span class="block font-black text-xl text-slate-900 leading-none">MEMET</span>
                    <span class="block text-[10px] font-bold text-orange-500 tracking-widest leading-none">RENTAL</span>
                </div>
                <button @click="mobileOpen = false" class="text-slate-500 hover:text-slate-900">
                    <i class="fa-solid fa-xmark text-xl"></i>
                </button>
            </div>

            <div class="flex-1 overflow-y-auto py-6 px-6 space-y-2">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $navItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($item['href']); ?>" @click="mobileOpen = false" class="block text-lg font-medium py-3 transition-colors border-b border-slate-50 last:border-0 text-slate-600 hover:text-orange-600">
                        <?php echo e($item['name']); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\Kumtura\memet-rental\memet-rental\resources\views/components/header.blade.php ENDPATH**/ ?>