<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['motor']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['motor']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="group bg-white rounded-2xl overflow-hidden border border-neutral-100 shadow-sm hover:shadow-xl transition-all duration-300 hover:-translate-y-1 flex flex-col h-full">
    
    <div class="relative h-36 md:h-48 overflow-hidden bg-neutral-100 shrink-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($motor->main_image): ?>
            <?php
                $imageSrc = $motor->main_image;
                if (!str_starts_with($imageSrc, 'http')) {
                    $imageSrc = asset('storage/' . $imageSrc);
                }
            ?>
            <img 
                src="<?php echo e($imageSrc); ?>" 
                alt="<?php echo e($motor->name); ?>" 
                class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700"
                onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1449426468159-d96dbf08f19f?w=800&h=600&fit=crop'; this.classList.add('opacity-70');"
            />
        <?php else: ?>
            <div class="w-full h-full flex items-center justify-center bg-linear-to-br from-slate-100 to-slate-200">
                <div class="text-center">
                    <i class="fa-solid fa-motorcycle text-3xl md:text-4xl text-slate-300 mb-2"></i>
                    <p class="text-[10px] md:text-xs text-slate-400">No Image</p>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        <div class="absolute inset-0 bg-black/20 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </div>

    
    <div class="p-3 md:p-5 flex flex-col grow">
        <div class="flex items-center gap-2 mb-1 md:mb-2">
             <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($motor->brand && $motor->brand->logo): ?>
                <img src="<?php echo e($motor->brand->logo); ?>" alt="<?php echo e($motor->brand->name); ?>" class="w-4 h-4 md:w-5 md:h-5 object-contain opacity-70" />
            <?php else: ?>
                <span class="text-[10px] md:text-xs font-semibold text-neutral-400 uppercase tracking-wider"><?php echo e($motor->brand->name ?? 'Unknown'); ?></span>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        
        <h3 class="text-sm md:text-lg font-bold text-neutral-800 mb-1 group-hover:text-[#dc8034] transition-colors line-clamp-1">
            <?php echo e($motor->name); ?>

        </h3>
        
        <div class="flex items-center gap-1 md:gap-2 mb-2 md:mb-4 text-[10px] md:text-xs text-neutral-500">
            <div class="flex items-center gap-1 bg-neutral-50 px-1.5 py-0.5 md:px-2 md:py-1 rounded">
                <span class="font-bold"><?php echo e($motor->cc); ?></span>
                <span>CC</span>
            </div>
            <div class="flex items-center gap-1 bg-neutral-50 px-1.5 py-0.5 md:px-2 md:py-1 rounded">
                <i class="fa-solid fa-gear text-[8px] md:text-[10px]"></i>
                <span><?php echo e($motor->transmission); ?></span>
            </div>
        </div>
        
        <div class="mt-auto pt-2 md:pt-4 border-t border-neutral-100 flex items-center justify-between">
            <div>
                <p class="hidden md:block text-xs text-neutral-400 uppercase tracking-wide font-medium">Daily Rate</p>
                <div class="flex items-baseline gap-1">
                    <span class="text-sm md:text-lg font-extrabold text-[#2b6497]">
                         Rp <?php echo e(number_format($motor->price_daily, 0, ',', '.')); ?>

                    </span>
                    <span class="text-[10px] md:text-xs text-neutral-400 font-medium">/day</span>
                </div>
            </div>
        </div>
        
        <div class="mt-3 md:mt-4 grid grid-cols-1 md:grid-cols-2 gap-2">
            <a 
                href="<?php echo e(route('motors.show', $motor->id)); ?>"
                class="inline-flex items-center justify-center px-3 py-1.5 md:px-4 md:py-2 bg-white border border-neutral-200 text-neutral-700 text-xs md:text-sm font-semibold rounded-lg hover:bg-neutral-50 hover:text-[#dc8034] hover:border-[#dc8034] transition-all w-full"
            >
                Detail
            </a>
            <a 
                href="https://wa.me/<?php echo e($whatsappNumber); ?>?text=Hello,%20I%20want%20to%20book%20<?php echo e(urlencode($motor->name)); ?>"
                target="_blank"
                class="inline-flex items-center justify-center px-3 py-1.5 md:px-4 md:py-2 bg-[#dc8034] text-white text-xs md:text-sm font-semibold rounded-lg hover:bg-[#dc8034]/90 shadow-md hover:shadow-lg hover:-translate-y-0.5 transition-all w-full"
            >
                <i class="fa-brands fa-whatsapp mr-1.5"></i>
                Book
            </a>
        </div>
    </div>
</div>
<?php /**PATH D:\Kumtura\memet-rental\memet-rental\resources\views/livewire/components/motor-card.blade.php ENDPATH**/ ?>